package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionSpecBuilder extends ClusterVersionSpecFluentImpl<ClusterVersionSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ClusterVersionSpec,io.fabric8.openshift.api.model.ClusterVersionSpecBuilder>{
  public ClusterVersionSpecBuilder() {
    this(false);
  }
  public ClusterVersionSpecBuilder(Boolean validationEnabled) {
    this(new ClusterVersionSpec(), validationEnabled);
  }
  public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionSpecBuilder(io.fabric8.openshift.api.model.ClusterVersionSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterVersionSpec(), validationEnabled);
  }
  public ClusterVersionSpecBuilder(io.fabric8.openshift.api.model.ClusterVersionSpecFluent<?> fluent,io.fabric8.openshift.api.model.ClusterVersionSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionSpecBuilder(io.fabric8.openshift.api.model.ClusterVersionSpecFluent<?> fluent,io.fabric8.openshift.api.model.ClusterVersionSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChannel(instance.getChannel()); 
    fluent.withClusterID(instance.getClusterID()); 
    fluent.withDesiredUpdate(instance.getDesiredUpdate()); 
    fluent.withOverrides(instance.getOverrides()); 
    fluent.withUpstream(instance.getUpstream()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionSpecBuilder(io.fabric8.openshift.api.model.ClusterVersionSpec instance) {
    this(instance,false);
  }
  public ClusterVersionSpecBuilder(io.fabric8.openshift.api.model.ClusterVersionSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withChannel(instance.getChannel()); 
    this.withClusterID(instance.getClusterID()); 
    this.withDesiredUpdate(instance.getDesiredUpdate()); 
    this.withOverrides(instance.getOverrides()); 
    this.withUpstream(instance.getUpstream()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterVersionSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterVersionSpec build() {
    ClusterVersionSpec buildable = new ClusterVersionSpec(fluent.getChannel(),fluent.getClusterID(),fluent.getDesiredUpdate(),fluent.getOverrides(),fluent.getUpstream());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}