package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionListBuilder extends ClusterVersionListFluentImpl<ClusterVersionListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ClusterVersionList,ClusterVersionListBuilder>{
  public ClusterVersionListBuilder() {
    this(false);
  }
  public ClusterVersionListBuilder(Boolean validationEnabled) {
    this(new ClusterVersionList(), validationEnabled);
  }
  public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionListBuilder(io.fabric8.openshift.api.model.ClusterVersionListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterVersionList(), validationEnabled);
  }
  public ClusterVersionListBuilder(io.fabric8.openshift.api.model.ClusterVersionListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterVersionList instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionListBuilder(io.fabric8.openshift.api.model.ClusterVersionListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterVersionList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionListBuilder(io.fabric8.openshift.api.model.ClusterVersionList instance) {
    this(instance,false);
  }
  public ClusterVersionListBuilder(io.fabric8.openshift.api.model.ClusterVersionList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterVersionListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterVersionList build() {
    ClusterVersionList buildable = new ClusterVersionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}