package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleBindingBuilder extends ClusterRoleBindingFluentImpl<ClusterRoleBindingBuilder> implements VisitableBuilder<ClusterRoleBinding,io.fabric8.openshift.api.model.ClusterRoleBindingBuilder>{
  public ClusterRoleBindingBuilder() {
    this(false);
  }
  public ClusterRoleBindingBuilder(Boolean validationEnabled) {
    this(new ClusterRoleBinding(), validationEnabled);
  }
  public ClusterRoleBindingBuilder(io.fabric8.openshift.api.model.ClusterRoleBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.openshift.api.model.ClusterRoleBindingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterRoleBinding(), validationEnabled);
  }
  public ClusterRoleBindingBuilder(io.fabric8.openshift.api.model.ClusterRoleBindingFluent<?> fluent,io.fabric8.openshift.api.model.ClusterRoleBinding instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.openshift.api.model.ClusterRoleBindingFluent<?> fluent,io.fabric8.openshift.api.model.ClusterRoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withGroupNames(instance.getGroupNames()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRoleRef(instance.getRoleRef()); 
    fluent.withSubjects(instance.getSubjects()); 
    fluent.withUserNames(instance.getUserNames()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBindingBuilder(io.fabric8.openshift.api.model.ClusterRoleBinding instance) {
    this(instance,false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.openshift.api.model.ClusterRoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroupNames(instance.getGroupNames()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRoleRef(instance.getRoleRef()); 
    this.withSubjects(instance.getSubjects()); 
    this.withUserNames(instance.getUserNames()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterRoleBindingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterRoleBinding build() {
    ClusterRoleBinding buildable = new ClusterRoleBinding(fluent.getApiVersion(),fluent.getGroupNames(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects(),fluent.getUserNames());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}