package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterResourceQuotaStatusBuilder extends ClusterResourceQuotaStatusFluentImpl<ClusterResourceQuotaStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ClusterResourceQuotaStatus,ClusterResourceQuotaStatusBuilder>{
  public ClusterResourceQuotaStatusBuilder() {
    this(false);
  }
  public ClusterResourceQuotaStatusBuilder(Boolean validationEnabled) {
    this(new ClusterResourceQuotaStatus(), validationEnabled);
  }
  public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterResourceQuotaStatusBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterResourceQuotaStatus(), validationEnabled);
  }
  public ClusterResourceQuotaStatusBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaStatusFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterResourceQuotaStatusBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaStatusFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNamespaces(instance.getNamespaces()); 
    fluent.withTotal(instance.getTotal()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterResourceQuotaStatusBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaStatus instance) {
    this(instance,false);
  }
  public ClusterResourceQuotaStatusBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNamespaces(instance.getNamespaces()); 
    this.withTotal(instance.getTotal()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterResourceQuotaStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterResourceQuotaStatus build() {
    ClusterResourceQuotaStatus buildable = new ClusterResourceQuotaStatus(fluent.getNamespaces(),fluent.getTotal());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}