package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterResourceQuotaSpecBuilder extends ClusterResourceQuotaSpecFluentImpl<ClusterResourceQuotaSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ClusterResourceQuotaSpec,io.fabric8.openshift.api.model.ClusterResourceQuotaSpecBuilder>{
  public ClusterResourceQuotaSpecBuilder() {
    this(false);
  }
  public ClusterResourceQuotaSpecBuilder(Boolean validationEnabled) {
    this(new ClusterResourceQuotaSpec(), validationEnabled);
  }
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterResourceQuotaSpec(), validationEnabled);
  }
  public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withQuota(instance.getQuota()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpec instance) {
    this(instance,false);
  }
  public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withQuota(instance.getQuota()); 
    this.withSelector(instance.getSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterResourceQuotaSpec build() {
    ClusterResourceQuotaSpec buildable = new ClusterResourceQuotaSpec(fluent.getQuota(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}