package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterResourceQuotaListBuilder extends ClusterResourceQuotaListFluentImpl<ClusterResourceQuotaListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ClusterResourceQuotaList,io.fabric8.openshift.api.model.ClusterResourceQuotaListBuilder>{
  public ClusterResourceQuotaListBuilder() {
    this(false);
  }
  public ClusterResourceQuotaListBuilder(Boolean validationEnabled) {
    this(new ClusterResourceQuotaList(), validationEnabled);
  }
  public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterResourceQuotaList(), validationEnabled);
  }
  public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaList instance) {
    this(fluent, instance, false);
  }
  public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaList instance) {
    this(instance,false);
  }
  public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterResourceQuotaList build() {
    ClusterResourceQuotaList buildable = new ClusterResourceQuotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}