package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterResourceQuotaBuilder extends ClusterResourceQuotaFluentImpl<ClusterResourceQuotaBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ClusterResourceQuota,io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder>{
  public ClusterResourceQuotaBuilder() {
    this(false);
  }
  public ClusterResourceQuotaBuilder(Boolean validationEnabled) {
    this(new ClusterResourceQuota(), validationEnabled);
  }
  public ClusterResourceQuotaBuilder(ClusterResourceQuotaFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterResourceQuota(), validationEnabled);
  }
  public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuota instance) {
    this(fluent, instance, false);
  }
  public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuota instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuota instance) {
    this(instance,false);
  }
  public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuota instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterResourceQuota build() {
    ClusterResourceQuota buildable = new ClusterResourceQuota(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}