package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterOperatorStatusFluentImpl<A extends ClusterOperatorStatusFluent<A>> extends BaseFluent<A> implements ClusterOperatorStatusFluent<A>{
  public ClusterOperatorStatusFluentImpl() {
  }
  public ClusterOperatorStatusFluentImpl(ClusterOperatorStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withExtension(instance.getExtension()); 
    this.withRelatedObjects(instance.getRelatedObjects()); 
    this.withVersions(instance.getVersions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ClusterOperatorStatusConditionBuilder> conditions = new java.util.ArrayList<ClusterOperatorStatusConditionBuilder>();
  private VisitableBuilder<? extends HasMetadata,?> extension;
  private java.util.ArrayList<ObjectReferenceBuilder> relatedObjects = new java.util.ArrayList<ObjectReferenceBuilder>();
  private java.util.ArrayList<OperandVersionBuilder> versions = new java.util.ArrayList<OperandVersionBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();}
    io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();}
    io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();}
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : items) {io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();}
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : items) {io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition... items) {
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : items) {io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> items) {
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : items) {io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  public ClusterOperatorStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ClusterOperatorStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
    return new ClusterOperatorStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.HasMetadata getExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public A withExtension(io.fabric8.kubernetes.api.model.HasMetadata extension) {
    if (extension instanceof ClusterVersion){ this.extension= new ClusterVersionBuilder((io.fabric8.openshift.api.model.ClusterVersion)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof DNS){ this.extension= new DNSBuilder((io.fabric8.openshift.api.model.DNS)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ImageStreamImport){ this.extension= new ImageStreamImportBuilder((ImageStreamImport)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Proxy){ this.extension= new ProxyBuilder((io.fabric8.openshift.api.model.Proxy)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Project){ this.extension= new ProjectBuilder((io.fabric8.openshift.api.model.Project)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ClusterOperator){ this.extension= new ClusterOperatorBuilder((io.fabric8.openshift.api.model.ClusterOperator)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof BuildConfig){ this.extension= new BuildConfigBuilder((BuildConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof HelmChartRepository){ this.extension= new HelmChartRepositoryBuilder((io.fabric8.openshift.api.model.HelmChartRepository)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Infrastructure){ this.extension= new InfrastructureBuilder((io.fabric8.openshift.api.model.Infrastructure)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Scheduler){ this.extension= new SchedulerBuilder((io.fabric8.openshift.api.model.Scheduler)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof RangeAllocation){ this.extension= new RangeAllocationBuilder((io.fabric8.openshift.api.model.RangeAllocation)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Route){ this.extension= new RouteBuilder((io.fabric8.openshift.api.model.Route)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ClusterNetwork){ this.extension= new ClusterNetworkBuilder((io.fabric8.openshift.api.model.ClusterNetwork)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof OAuthAuthorizeToken){ this.extension= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof UserOAuthAccessToken){ this.extension= new UserOAuthAccessTokenBuilder((UserOAuthAccessToken)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Ingress){ this.extension= new IngressBuilder((io.fabric8.openshift.api.model.Ingress)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.OAuth){ this.extension= new OAuthBuilder((io.fabric8.openshift.api.model.OAuth)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof OperatorHub){ this.extension= new OperatorHubBuilder((io.fabric8.openshift.api.model.OperatorHub)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ClusterRoleBinding){ this.extension= new ClusterRoleBindingBuilder((io.fabric8.openshift.api.model.ClusterRoleBinding)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ClusterResourceQuota){ this.extension= new ClusterResourceQuotaBuilder((io.fabric8.openshift.api.model.ClusterResourceQuota)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ProjectRequest){ this.extension= new ProjectRequestBuilder((io.fabric8.openshift.api.model.ProjectRequest)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Template){ this.extension= new TemplateBuilder((io.fabric8.openshift.api.model.Template)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof OAuthClientAuthorization){ this.extension= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ClusterRole){ this.extension= new ClusterRoleBuilder((io.fabric8.openshift.api.model.ClusterRole)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Authentication){ this.extension= new AuthenticationBuilder((io.fabric8.openshift.api.model.Authentication)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ImageTag){ this.extension= new ImageTagBuilder((io.fabric8.openshift.api.model.ImageTag)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof OAuthAccessToken){ this.extension= new OAuthAccessTokenBuilder((io.fabric8.openshift.api.model.OAuthAccessToken)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof DeploymentConfig){ this.extension= new DeploymentConfigBuilder((io.fabric8.openshift.api.model.DeploymentConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof RoleBinding){ this.extension= new RoleBindingBuilder((io.fabric8.openshift.api.model.RoleBinding)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Image){ this.extension= new ImageBuilder((io.fabric8.openshift.api.model.Image)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIServer){ this.extension= new APIServerBuilder((io.fabric8.openshift.api.model.APIServer)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaim){ this.extension= new PersistentVolumeClaimBuilder((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ImageStreamMapping){ this.extension= new ImageStreamMappingBuilder((io.fabric8.openshift.api.model.ImageStreamMapping)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Role){ this.extension= new RoleBuilder((io.fabric8.openshift.api.model.Role)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof BrokerTemplateInstance){ this.extension= new BrokerTemplateInstanceBuilder((io.fabric8.openshift.api.model.BrokerTemplateInstance)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof FeatureGate){ this.extension= new FeatureGateBuilder((io.fabric8.openshift.api.model.FeatureGate)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.User){ this.extension= new UserBuilder((io.fabric8.openshift.api.model.User)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ImageStreamImage){ this.extension= new ImageStreamImageBuilder((io.fabric8.openshift.api.model.ImageStreamImage)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof TemplateInstance){ this.extension= new TemplateInstanceBuilder((io.fabric8.openshift.api.model.TemplateInstance)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Build){ this.extension= new BuildBuilder((io.fabric8.openshift.api.model.Build)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof RoleBindingRestriction){ this.extension= new RoleBindingRestrictionBuilder((io.fabric8.openshift.api.model.RoleBindingRestriction)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ImageStreamTag){ this.extension= new ImageStreamTagBuilder((io.fabric8.openshift.api.model.ImageStreamTag)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Group){ this.extension= new GroupBuilder((io.fabric8.openshift.api.model.Group)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ImageSignature){ this.extension= new ImageSignatureBuilder((io.fabric8.openshift.api.model.ImageSignature)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof HostSubnet){ this.extension= new HostSubnetBuilder((io.fabric8.openshift.api.model.HostSubnet)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof AppliedClusterResourceQuota){ this.extension= new AppliedClusterResourceQuotaBuilder((io.fabric8.openshift.api.model.AppliedClusterResourceQuota)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof SecurityContextConstraints){ this.extension= new SecurityContextConstraintsBuilder((io.fabric8.openshift.api.model.SecurityContextConstraints)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Console){ this.extension= new ConsoleBuilder((io.fabric8.openshift.api.model.Console)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof BuildRequest){ this.extension= new BuildRequestBuilder((io.fabric8.openshift.api.model.BuildRequest)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof EgressNetworkPolicy){ this.extension= new EgressNetworkPolicyBuilder((io.fabric8.openshift.api.model.EgressNetworkPolicy)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof NetNamespace){ this.extension= new NetNamespaceBuilder((io.fabric8.openshift.api.model.NetNamespace)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof UserIdentityMapping){ this.extension= new UserIdentityMappingBuilder((io.fabric8.openshift.api.model.UserIdentityMapping)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ImageStream){ this.extension= new ImageStreamBuilder((io.fabric8.openshift.api.model.ImageStream)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Network){ this.extension= new NetworkBuilder((io.fabric8.openshift.api.model.Network)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.OAuthClient){ this.extension= new OAuthClientBuilder((io.fabric8.openshift.api.model.OAuthClient)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Identity){ this.extension= new IdentityBuilder((io.fabric8.openshift.api.model.Identity)extension); _visitables.get("extension").add(this.extension);}
    return (A) this;
  }
  public java.lang.Boolean hasExtension() {
    return this.extension != null;
  }
  public A withClusterVersionExtension(io.fabric8.openshift.api.model.ClusterVersion clusterVersionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterVersionExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterVersionBuilder(clusterVersionExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtension() {
    return new ClusterOperatorStatusFluentImpl.ClusterVersionExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtensionLike(io.fabric8.openshift.api.model.ClusterVersion item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterVersionExtensionNestedImpl(item);
  }
  public A withDNSExtension(io.fabric8.openshift.api.model.DNS dNSExtension) {
    _visitables.get("extension").remove(this.extension);
    if (dNSExtension!=null){ this.extension= new io.fabric8.openshift.api.model.DNSBuilder(dNSExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.DNSExtensionNested<A> withNewDNSExtension() {
    return new ClusterOperatorStatusFluentImpl.DNSExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DNSExtensionNested<A> withNewDNSExtensionLike(io.fabric8.openshift.api.model.DNS item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.DNSExtensionNestedImpl(item);
  }
  public A withImageStreamImportExtension(io.fabric8.openshift.api.model.ImageStreamImport imageStreamImportExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamImportExtension!=null){ this.extension= new ImageStreamImportBuilder(imageStreamImportExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageStreamImportExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtensionLike(io.fabric8.openshift.api.model.ImageStreamImport item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamImportExtensionNestedImpl(item);
  }
  public A withProxyExtension(io.fabric8.openshift.api.model.Proxy proxyExtension) {
    _visitables.get("extension").remove(this.extension);
    if (proxyExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ProxyBuilder(proxyExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtension() {
    return new ClusterOperatorStatusFluentImpl.ProxyExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtensionLike(io.fabric8.openshift.api.model.Proxy item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProxyExtensionNestedImpl(item);
  }
  public A withProjectExtension(io.fabric8.openshift.api.model.Project projectExtension) {
    _visitables.get("extension").remove(this.extension);
    if (projectExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ProjectBuilder(projectExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtension() {
    return new ClusterOperatorStatusFluentImpl.ProjectExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtensionLike(io.fabric8.openshift.api.model.Project item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProjectExtensionNestedImpl(item);
  }
  public A withClusterOperatorExtension(io.fabric8.openshift.api.model.ClusterOperator clusterOperatorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterOperatorExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterOperatorBuilder(clusterOperatorExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtension() {
    return new ClusterOperatorStatusFluentImpl.ClusterOperatorExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtensionLike(io.fabric8.openshift.api.model.ClusterOperator item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterOperatorExtensionNestedImpl(item);
  }
  public A withBuildConfigExtension(io.fabric8.openshift.api.model.BuildConfig buildConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (buildConfigExtension!=null){ this.extension= new io.fabric8.openshift.api.model.BuildConfigBuilder(buildConfigExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtension() {
    return new ClusterOperatorStatusFluentImpl.BuildConfigExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtensionLike(io.fabric8.openshift.api.model.BuildConfig item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildConfigExtensionNestedImpl(item);
  }
  public A withHelmChartRepositoryExtension(io.fabric8.openshift.api.model.HelmChartRepository helmChartRepositoryExtension) {
    _visitables.get("extension").remove(this.extension);
    if (helmChartRepositoryExtension!=null){ this.extension= new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(helmChartRepositoryExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.HelmChartRepositoryExtensionNested<A> withNewHelmChartRepositoryExtension() {
    return new ClusterOperatorStatusFluentImpl.HelmChartRepositoryExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HelmChartRepositoryExtensionNested<A> withNewHelmChartRepositoryExtensionLike(io.fabric8.openshift.api.model.HelmChartRepository item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.HelmChartRepositoryExtensionNestedImpl(item);
  }
  public A withInfrastructureExtension(io.fabric8.openshift.api.model.Infrastructure infrastructureExtension) {
    _visitables.get("extension").remove(this.extension);
    if (infrastructureExtension!=null){ this.extension= new io.fabric8.openshift.api.model.InfrastructureBuilder(infrastructureExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtension() {
    return new ClusterOperatorStatusFluentImpl.InfrastructureExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtensionLike(io.fabric8.openshift.api.model.Infrastructure item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.InfrastructureExtensionNestedImpl(item);
  }
  public A withSchedulerExtension(io.fabric8.openshift.api.model.Scheduler schedulerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (schedulerExtension!=null){ this.extension= new io.fabric8.openshift.api.model.SchedulerBuilder(schedulerExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtension() {
    return new ClusterOperatorStatusFluentImpl.SchedulerExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtensionLike(io.fabric8.openshift.api.model.Scheduler item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.SchedulerExtensionNestedImpl(item);
  }
  public A withRangeAllocationExtension(io.fabric8.openshift.api.model.RangeAllocation rangeAllocationExtension) {
    _visitables.get("extension").remove(this.extension);
    if (rangeAllocationExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RangeAllocationBuilder(rangeAllocationExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtension() {
    return new ClusterOperatorStatusFluentImpl.RangeAllocationExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtensionLike(io.fabric8.openshift.api.model.RangeAllocation item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RangeAllocationExtensionNestedImpl(item);
  }
  public A withRouteExtension(io.fabric8.openshift.api.model.Route routeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (routeExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RouteBuilder(routeExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtension() {
    return new ClusterOperatorStatusFluentImpl.RouteExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtensionLike(io.fabric8.openshift.api.model.Route item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RouteExtensionNestedImpl(item);
  }
  public A withClusterNetworkExtension(io.fabric8.openshift.api.model.ClusterNetwork clusterNetworkExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterNetworkExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterNetworkBuilder(clusterNetworkExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtension() {
    return new ClusterOperatorStatusFluentImpl.ClusterNetworkExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtensionLike(io.fabric8.openshift.api.model.ClusterNetwork item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterNetworkExtensionNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenExtension(io.fabric8.openshift.api.model.OAuthAuthorizeToken oAuthAuthorizeTokenExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthAuthorizeTokenExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtension() {
    return new ClusterOperatorStatusFluentImpl.OAuthAuthorizeTokenExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtensionLike(io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthAuthorizeTokenExtensionNestedImpl(item);
  }
  public A withUserOAuthAccessTokenExtension(io.fabric8.openshift.api.model.UserOAuthAccessToken userOAuthAccessTokenExtension) {
    _visitables.get("extension").remove(this.extension);
    if (userOAuthAccessTokenExtension!=null){ this.extension= new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(userOAuthAccessTokenExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.UserOAuthAccessTokenExtensionNested<A> withNewUserOAuthAccessTokenExtension() {
    return new ClusterOperatorStatusFluentImpl.UserOAuthAccessTokenExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserOAuthAccessTokenExtensionNested<A> withNewUserOAuthAccessTokenExtensionLike(io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserOAuthAccessTokenExtensionNestedImpl(item);
  }
  public A withIngressExtension(io.fabric8.openshift.api.model.Ingress ingressExtension) {
    _visitables.get("extension").remove(this.extension);
    if (ingressExtension!=null){ this.extension= new io.fabric8.openshift.api.model.IngressBuilder(ingressExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.IngressExtensionNested<A> withNewIngressExtension() {
    return new ClusterOperatorStatusFluentImpl.IngressExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<A> withNewIngressExtensionLike(io.fabric8.openshift.api.model.Ingress item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.IngressExtensionNestedImpl(item);
  }
  public A withOAuthExtension(io.fabric8.openshift.api.model.OAuth oAuthExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthBuilder(oAuthExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtension() {
    return new ClusterOperatorStatusFluentImpl.OAuthExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtensionLike(io.fabric8.openshift.api.model.OAuth item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthExtensionNestedImpl(item);
  }
  public A withOperatorHubExtension(io.fabric8.openshift.api.model.OperatorHub operatorHubExtension) {
    _visitables.get("extension").remove(this.extension);
    if (operatorHubExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OperatorHubBuilder(operatorHubExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtension() {
    return new ClusterOperatorStatusFluentImpl.OperatorHubExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtensionLike(io.fabric8.openshift.api.model.OperatorHub item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OperatorHubExtensionNestedImpl(item);
  }
  public A withClusterRoleBindingExtension(io.fabric8.openshift.api.model.ClusterRoleBinding clusterRoleBindingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterRoleBindingExtension!=null){ this.extension= new ClusterRoleBindingBuilder(clusterRoleBindingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtension() {
    return new ClusterOperatorStatusFluentImpl.ClusterRoleBindingExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtensionLike(io.fabric8.openshift.api.model.ClusterRoleBinding item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterRoleBindingExtensionNestedImpl(item);
  }
  public A withClusterResourceQuotaExtension(io.fabric8.openshift.api.model.ClusterResourceQuota clusterResourceQuotaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterResourceQuotaExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(clusterResourceQuotaExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtension() {
    return new ClusterOperatorStatusFluentImpl.ClusterResourceQuotaExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtensionLike(io.fabric8.openshift.api.model.ClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterResourceQuotaExtensionNestedImpl(item);
  }
  public A withProjectRequestExtension(io.fabric8.openshift.api.model.ProjectRequest projectRequestExtension) {
    _visitables.get("extension").remove(this.extension);
    if (projectRequestExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ProjectRequestBuilder(projectRequestExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtension() {
    return new ClusterOperatorStatusFluentImpl.ProjectRequestExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtensionLike(io.fabric8.openshift.api.model.ProjectRequest item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProjectRequestExtensionNestedImpl(item);
  }
  public A withTemplateExtension(io.fabric8.openshift.api.model.Template templateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (templateExtension!=null){ this.extension= new io.fabric8.openshift.api.model.TemplateBuilder(templateExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtension() {
    return new ClusterOperatorStatusFluentImpl.TemplateExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtensionLike(io.fabric8.openshift.api.model.Template item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.TemplateExtensionNestedImpl(item);
  }
  public A withOAuthClientAuthorizationExtension(io.fabric8.openshift.api.model.OAuthClientAuthorization oAuthClientAuthorizationExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthClientAuthorizationExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(oAuthClientAuthorizationExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtension() {
    return new ClusterOperatorStatusFluentImpl.OAuthClientAuthorizationExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtensionLike(io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthClientAuthorizationExtensionNestedImpl(item);
  }
  public A withClusterRoleExtension(io.fabric8.openshift.api.model.ClusterRole clusterRoleExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterRoleExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterRoleBuilder(clusterRoleExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtension() {
    return new ClusterOperatorStatusFluentImpl.ClusterRoleExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtensionLike(io.fabric8.openshift.api.model.ClusterRole item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterRoleExtensionNestedImpl(item);
  }
  public A withAuthenticationExtension(io.fabric8.openshift.api.model.Authentication authenticationExtension) {
    _visitables.get("extension").remove(this.extension);
    if (authenticationExtension!=null){ this.extension= new io.fabric8.openshift.api.model.AuthenticationBuilder(authenticationExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.AuthenticationExtensionNested<A> withNewAuthenticationExtension() {
    return new ClusterOperatorStatusFluentImpl.AuthenticationExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AuthenticationExtensionNested<A> withNewAuthenticationExtensionLike(io.fabric8.openshift.api.model.Authentication item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.AuthenticationExtensionNestedImpl(item);
  }
  public A withImageTagExtension(io.fabric8.openshift.api.model.ImageTag imageTagExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageTagExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageTagBuilder(imageTagExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageTagExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtensionLike(io.fabric8.openshift.api.model.ImageTag item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageTagExtensionNestedImpl(item);
  }
  public A withOAuthAccessTokenExtension(io.fabric8.openshift.api.model.OAuthAccessToken oAuthAccessTokenExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthAccessTokenExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(oAuthAccessTokenExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtension() {
    return new ClusterOperatorStatusFluentImpl.OAuthAccessTokenExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtensionLike(io.fabric8.openshift.api.model.OAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthAccessTokenExtensionNestedImpl(item);
  }
  public A withDeploymentConfigExtension(io.fabric8.openshift.api.model.DeploymentConfig deploymentConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (deploymentConfigExtension!=null){ this.extension= new io.fabric8.openshift.api.model.DeploymentConfigBuilder(deploymentConfigExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtension() {
    return new ClusterOperatorStatusFluentImpl.DeploymentConfigExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtensionLike(io.fabric8.openshift.api.model.DeploymentConfig item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.DeploymentConfigExtensionNestedImpl(item);
  }
  public A withRoleBindingExtension(io.fabric8.openshift.api.model.RoleBinding roleBindingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (roleBindingExtension!=null){ this.extension= new RoleBindingBuilder(roleBindingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtension() {
    return new ClusterOperatorStatusFluentImpl.RoleBindingExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtensionLike(io.fabric8.openshift.api.model.RoleBinding item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleBindingExtensionNestedImpl(item);
  }
  public A withImageExtension(io.fabric8.openshift.api.model.Image imageExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageBuilder(imageExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtensionLike(io.fabric8.openshift.api.model.Image item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageExtensionNestedImpl(item);
  }
  public A withAPIServerExtension(io.fabric8.openshift.api.model.APIServer aPIServerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServerExtension!=null){ this.extension= new io.fabric8.openshift.api.model.APIServerBuilder(aPIServerExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtension() {
    return new ClusterOperatorStatusFluentImpl.APIServerExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtensionLike(io.fabric8.openshift.api.model.APIServer item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.APIServerExtensionNestedImpl(item);
  }
  public A withPersistentVolumeClaimExtension(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimExtension!=null){ this.extension= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaimExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension() {
    return new ClusterOperatorStatusFluentImpl.PersistentVolumeClaimExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.PersistentVolumeClaimExtensionNestedImpl(item);
  }
  public A withImageStreamMappingExtension(io.fabric8.openshift.api.model.ImageStreamMapping imageStreamMappingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamMappingExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(imageStreamMappingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageStreamMappingExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtensionLike(io.fabric8.openshift.api.model.ImageStreamMapping item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamMappingExtensionNestedImpl(item);
  }
  public A withRoleExtension(io.fabric8.openshift.api.model.Role roleExtension) {
    _visitables.get("extension").remove(this.extension);
    if (roleExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RoleBuilder(roleExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtension() {
    return new ClusterOperatorStatusFluentImpl.RoleExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtensionLike(io.fabric8.openshift.api.model.Role item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleExtensionNestedImpl(item);
  }
  public A withBrokerTemplateInstanceExtension(io.fabric8.openshift.api.model.BrokerTemplateInstance brokerTemplateInstanceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (brokerTemplateInstanceExtension!=null){ this.extension= new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(brokerTemplateInstanceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.BrokerTemplateInstanceExtensionNested<A> withNewBrokerTemplateInstanceExtension() {
    return new ClusterOperatorStatusFluentImpl.BrokerTemplateInstanceExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BrokerTemplateInstanceExtensionNested<A> withNewBrokerTemplateInstanceExtensionLike(io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BrokerTemplateInstanceExtensionNestedImpl(item);
  }
  public A withFeatureGateExtension(io.fabric8.openshift.api.model.FeatureGate featureGateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (featureGateExtension!=null){ this.extension= new io.fabric8.openshift.api.model.FeatureGateBuilder(featureGateExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtension() {
    return new ClusterOperatorStatusFluentImpl.FeatureGateExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtensionLike(io.fabric8.openshift.api.model.FeatureGate item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.FeatureGateExtensionNestedImpl(item);
  }
  public A withUserExtension(io.fabric8.openshift.api.model.User userExtension) {
    _visitables.get("extension").remove(this.extension);
    if (userExtension!=null){ this.extension= new io.fabric8.openshift.api.model.UserBuilder(userExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtension() {
    return new ClusterOperatorStatusFluentImpl.UserExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtensionLike(io.fabric8.openshift.api.model.User item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserExtensionNestedImpl(item);
  }
  public A withImageStreamImageExtension(io.fabric8.openshift.api.model.ImageStreamImage imageStreamImageExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamImageExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamImageBuilder(imageStreamImageExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageStreamImageExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtensionLike(io.fabric8.openshift.api.model.ImageStreamImage item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamImageExtensionNestedImpl(item);
  }
  public A withTemplateInstanceExtension(io.fabric8.openshift.api.model.TemplateInstance templateInstanceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (templateInstanceExtension!=null){ this.extension= new io.fabric8.openshift.api.model.TemplateInstanceBuilder(templateInstanceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.TemplateInstanceExtensionNested<A> withNewTemplateInstanceExtension() {
    return new ClusterOperatorStatusFluentImpl.TemplateInstanceExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateInstanceExtensionNested<A> withNewTemplateInstanceExtensionLike(io.fabric8.openshift.api.model.TemplateInstance item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.TemplateInstanceExtensionNestedImpl(item);
  }
  public A withBuildExtension(io.fabric8.openshift.api.model.Build buildExtension) {
    _visitables.get("extension").remove(this.extension);
    if (buildExtension!=null){ this.extension= new io.fabric8.openshift.api.model.BuildBuilder(buildExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtension() {
    return new ClusterOperatorStatusFluentImpl.BuildExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtensionLike(io.fabric8.openshift.api.model.Build item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildExtensionNestedImpl(item);
  }
  public A withRoleBindingRestrictionExtension(io.fabric8.openshift.api.model.RoleBindingRestriction roleBindingRestrictionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (roleBindingRestrictionExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(roleBindingRestrictionExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtension() {
    return new ClusterOperatorStatusFluentImpl.RoleBindingRestrictionExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtensionLike(io.fabric8.openshift.api.model.RoleBindingRestriction item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleBindingRestrictionExtensionNestedImpl(item);
  }
  public A withImageStreamTagExtension(io.fabric8.openshift.api.model.ImageStreamTag imageStreamTagExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamTagExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamTagBuilder(imageStreamTagExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageStreamTagExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtensionLike(io.fabric8.openshift.api.model.ImageStreamTag item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamTagExtensionNestedImpl(item);
  }
  public A withGroupExtension(io.fabric8.openshift.api.model.Group groupExtension) {
    _visitables.get("extension").remove(this.extension);
    if (groupExtension!=null){ this.extension= new io.fabric8.openshift.api.model.GroupBuilder(groupExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtension() {
    return new ClusterOperatorStatusFluentImpl.GroupExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtensionLike(io.fabric8.openshift.api.model.Group item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.GroupExtensionNestedImpl(item);
  }
  public A withImageSignatureExtension(io.fabric8.openshift.api.model.ImageSignature imageSignatureExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageSignatureExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageSignatureBuilder(imageSignatureExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageSignatureExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtensionLike(io.fabric8.openshift.api.model.ImageSignature item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageSignatureExtensionNestedImpl(item);
  }
  public A withHostSubnetExtension(io.fabric8.openshift.api.model.HostSubnet hostSubnetExtension) {
    _visitables.get("extension").remove(this.extension);
    if (hostSubnetExtension!=null){ this.extension= new io.fabric8.openshift.api.model.HostSubnetBuilder(hostSubnetExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.HostSubnetExtensionNested<A> withNewHostSubnetExtension() {
    return new ClusterOperatorStatusFluentImpl.HostSubnetExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HostSubnetExtensionNested<A> withNewHostSubnetExtensionLike(io.fabric8.openshift.api.model.HostSubnet item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.HostSubnetExtensionNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaExtension(io.fabric8.openshift.api.model.AppliedClusterResourceQuota appliedClusterResourceQuotaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (appliedClusterResourceQuotaExtension!=null){ this.extension= new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtension() {
    return new ClusterOperatorStatusFluentImpl.AppliedClusterResourceQuotaExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtensionLike(io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.AppliedClusterResourceQuotaExtensionNestedImpl(item);
  }
  public A withSecurityContextConstraintsExtension(io.fabric8.openshift.api.model.SecurityContextConstraints securityContextConstraintsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (securityContextConstraintsExtension!=null){ this.extension= new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(securityContextConstraintsExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtension() {
    return new ClusterOperatorStatusFluentImpl.SecurityContextConstraintsExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtensionLike(io.fabric8.openshift.api.model.SecurityContextConstraints item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.SecurityContextConstraintsExtensionNestedImpl(item);
  }
  public A withConsoleExtension(io.fabric8.openshift.api.model.Console consoleExtension) {
    _visitables.get("extension").remove(this.extension);
    if (consoleExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ConsoleBuilder(consoleExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ConsoleExtensionNested<A> withNewConsoleExtension() {
    return new ClusterOperatorStatusFluentImpl.ConsoleExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConsoleExtensionNested<A> withNewConsoleExtensionLike(io.fabric8.openshift.api.model.Console item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ConsoleExtensionNestedImpl(item);
  }
  public A withBuildRequestExtension(io.fabric8.openshift.api.model.BuildRequest buildRequestExtension) {
    _visitables.get("extension").remove(this.extension);
    if (buildRequestExtension!=null){ this.extension= new io.fabric8.openshift.api.model.BuildRequestBuilder(buildRequestExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtension() {
    return new ClusterOperatorStatusFluentImpl.BuildRequestExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtensionLike(io.fabric8.openshift.api.model.BuildRequest item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildRequestExtensionNestedImpl(item);
  }
  public A withEgressNetworkPolicyExtension(io.fabric8.openshift.api.model.EgressNetworkPolicy egressNetworkPolicyExtension) {
    _visitables.get("extension").remove(this.extension);
    if (egressNetworkPolicyExtension!=null){ this.extension= new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(egressNetworkPolicyExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtension() {
    return new ClusterOperatorStatusFluentImpl.EgressNetworkPolicyExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtensionLike(io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.EgressNetworkPolicyExtensionNestedImpl(item);
  }
  public A withNetNamespaceExtension(io.fabric8.openshift.api.model.NetNamespace netNamespaceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (netNamespaceExtension!=null){ this.extension= new io.fabric8.openshift.api.model.NetNamespaceBuilder(netNamespaceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtension() {
    return new ClusterOperatorStatusFluentImpl.NetNamespaceExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtensionLike(io.fabric8.openshift.api.model.NetNamespace item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.NetNamespaceExtensionNestedImpl(item);
  }
  public A withUserIdentityMappingExtension(io.fabric8.openshift.api.model.UserIdentityMapping userIdentityMappingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (userIdentityMappingExtension!=null){ this.extension= new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(userIdentityMappingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.UserIdentityMappingExtensionNested<A> withNewUserIdentityMappingExtension() {
    return new ClusterOperatorStatusFluentImpl.UserIdentityMappingExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserIdentityMappingExtensionNested<A> withNewUserIdentityMappingExtensionLike(io.fabric8.openshift.api.model.UserIdentityMapping item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserIdentityMappingExtensionNestedImpl(item);
  }
  public A withImageStreamExtension(io.fabric8.openshift.api.model.ImageStream imageStreamExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamBuilder(imageStreamExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtension() {
    return new ClusterOperatorStatusFluentImpl.ImageStreamExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtensionLike(io.fabric8.openshift.api.model.ImageStream item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamExtensionNestedImpl(item);
  }
  public A withNetworkExtension(io.fabric8.openshift.api.model.Network networkExtension) {
    _visitables.get("extension").remove(this.extension);
    if (networkExtension!=null){ this.extension= new io.fabric8.openshift.api.model.NetworkBuilder(networkExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.NetworkExtensionNested<A> withNewNetworkExtension() {
    return new ClusterOperatorStatusFluentImpl.NetworkExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetworkExtensionNested<A> withNewNetworkExtensionLike(io.fabric8.openshift.api.model.Network item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.NetworkExtensionNestedImpl(item);
  }
  public A withOAuthClientExtension(io.fabric8.openshift.api.model.OAuthClient oAuthClientExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthClientExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthClientBuilder(oAuthClientExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtension() {
    return new ClusterOperatorStatusFluentImpl.OAuthClientExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtensionLike(io.fabric8.openshift.api.model.OAuthClient item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthClientExtensionNestedImpl(item);
  }
  public A withIdentityExtension(io.fabric8.openshift.api.model.Identity identityExtension) {
    _visitables.get("extension").remove(this.extension);
    if (identityExtension!=null){ this.extension= new io.fabric8.openshift.api.model.IdentityBuilder(identityExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtension() {
    return new ClusterOperatorStatusFluentImpl.IdentityExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtensionLike(io.fabric8.openshift.api.model.Identity item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.IdentityExtensionNestedImpl(item);
  }
  public A addToRelatedObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(index >= 0 ? index : _visitables.get("relatedObjects").size(), builder);this.relatedObjects.add(index >= 0 ? index : relatedObjects.size(), builder); return (A)this;
  }
  public A setToRelatedObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("relatedObjects").size()) { _visitables.get("relatedObjects").add(builder); } else { _visitables.get("relatedObjects").set(index, builder);}
    if (index < 0 || index >= relatedObjects.size()) { relatedObjects.add(builder); } else { relatedObjects.set(index, builder);}
     return (A)this;
  }
  public A addToRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A addAllToRelatedObjects(java.util.Collection<io.fabric8.openshift.api.model.ObjectReference> items) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A removeFromRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items) {
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelatedObjects(java.util.Collection<io.fabric8.openshift.api.model.ObjectReference> items) {
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelatedObjects(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    if (relatedObjects == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ObjectReferenceBuilder> each = relatedObjects.iterator();
    final List visitables = _visitables.get("relatedObjects");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelatedObjects instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ObjectReference> getRelatedObjects() {
    return relatedObjects != null ? build(relatedObjects) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ObjectReference> buildRelatedObjects() {
    return relatedObjects != null ? build(relatedObjects) : null;
  }
  public io.fabric8.openshift.api.model.ObjectReference buildRelatedObject(java.lang.Integer index) {
    return this.relatedObjects.get(index).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildFirstRelatedObject() {
    return this.relatedObjects.get(0).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildLastRelatedObject() {
    return this.relatedObjects.get(relatedObjects.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedObjects(java.util.List<io.fabric8.openshift.api.model.ObjectReference> relatedObjects) {
    if (this.relatedObjects != null) { _visitables.get("relatedObjects").removeAll(this.relatedObjects);}
    if (relatedObjects != null) {this.relatedObjects = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ObjectReference item : relatedObjects){this.addToRelatedObjects(item);}} else { this.relatedObjects = null;} return (A) this;
  }
  public A withRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... relatedObjects) {
    if (this.relatedObjects != null) {this.relatedObjects.clear();}
    if (relatedObjects != null) {for (io.fabric8.openshift.api.model.ObjectReference item :relatedObjects){ this.addToRelatedObjects(item);}} return (A) this;
  }
  public java.lang.Boolean hasRelatedObjects() {
    return relatedObjects != null && !relatedObjects.isEmpty();
  }
  public A addNewRelatedObject(java.lang.String group,java.lang.String name,java.lang.String namespace,java.lang.String resource) {
    return (A)addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
  }
  public ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObject() {
    return new ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(io.fabric8.openshift.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editRelatedObject(java.lang.Integer index) {
    if (relatedObjects.size() <= index) throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject() {
    if (relatedObjects.size() == 0) throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(0, buildRelatedObject(0));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editLastRelatedObject() {
    int index = relatedObjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedObjects.size();i++) { 
    if (predicate.test(relatedObjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public A addToVersions(java.lang.Integer index,io.fabric8.openshift.api.model.OperandVersion item) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();}
    io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
  }
  public A setToVersions(java.lang.Integer index,io.fabric8.openshift.api.model.OperandVersion item) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();}
    io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);
    if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
    if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
     return (A)this;
  }
  public A addToVersions(io.fabric8.openshift.api.model.OperandVersion... items) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();}
    for (io.fabric8.openshift.api.model.OperandVersion item : items) {io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A addAllToVersions(java.util.Collection<io.fabric8.openshift.api.model.OperandVersion> items) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();}
    for (io.fabric8.openshift.api.model.OperandVersion item : items) {io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A removeFromVersions(io.fabric8.openshift.api.model.OperandVersion... items) {
    for (io.fabric8.openshift.api.model.OperandVersion item : items) {io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeAllFromVersions(java.util.Collection<io.fabric8.openshift.api.model.OperandVersion> items) {
    for (io.fabric8.openshift.api.model.OperandVersion item : items) {io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVersions(java.util.function.Predicate<io.fabric8.openshift.api.model.OperandVersionBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.OperandVersionBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.OperandVersionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVersions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.OperandVersion> getVersions() {
    return versions != null ? build(versions) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.OperandVersion> buildVersions() {
    return versions != null ? build(versions) : null;
  }
  public io.fabric8.openshift.api.model.OperandVersion buildVersion(java.lang.Integer index) {
    return this.versions.get(index).build();
  }
  public io.fabric8.openshift.api.model.OperandVersion buildFirstVersion() {
    return this.versions.get(0).build();
  }
  public io.fabric8.openshift.api.model.OperandVersion buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.OperandVersion buildMatchingVersion(java.util.function.Predicate<io.fabric8.openshift.api.model.OperandVersionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.OperandVersionBuilder item: versions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVersion(java.util.function.Predicate<io.fabric8.openshift.api.model.OperandVersionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.OperandVersionBuilder item: versions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVersions(java.util.List<io.fabric8.openshift.api.model.OperandVersion> versions) {
    if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
    if (versions != null) {this.versions = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.OperandVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
  }
  public A withVersions(io.fabric8.openshift.api.model.OperandVersion... versions) {
    if (this.versions != null) {this.versions.clear();}
    if (versions != null) {for (io.fabric8.openshift.api.model.OperandVersion item :versions){ this.addToVersions(item);}} return (A) this;
  }
  public java.lang.Boolean hasVersions() {
    return versions != null && !versions.isEmpty();
  }
  public A addNewVersion(java.lang.String name,java.lang.String version) {
    return (A)addToVersions(new OperandVersion(name, version));
  }
  public ClusterOperatorStatusFluent.VersionsNested<A> addNewVersion() {
    return new ClusterOperatorStatusFluentImpl.VersionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> addNewVersionLike(io.fabric8.openshift.api.model.OperandVersion item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.VersionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> setNewVersionLike(java.lang.Integer index,io.fabric8.openshift.api.model.OperandVersion item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.VersionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editVersion(java.lang.Integer index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editMatchingVersion(java.util.function.Predicate<io.fabric8.openshift.api.model.OperandVersionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterOperatorStatusFluentImpl that = (ClusterOperatorStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (relatedObjects != null ? !relatedObjects.equals(that.relatedObjects) :that.relatedObjects != null) return false;
    if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  extension,  relatedObjects,  versions,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (relatedObjects != null && !relatedObjects.isEmpty()) { sb.append("relatedObjects:"); sb.append(relatedObjects + ","); }
    if (versions != null && !versions.isEmpty()) { sb.append("versions:"); sb.append(versions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ClusterOperatorStatusConditionFluentImpl<ClusterOperatorStatusFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
      this.index = index;
      this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ClusterVersionExtensionNestedImpl<N> extends ClusterVersionFluentImpl<ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterVersionExtensionNestedImpl(ClusterVersion item) {
      this.builder = new ClusterVersionBuilder(this, item);
    }
    ClusterVersionExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterVersionBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterVersionExtension() {
      return and();
    }
    
  }
  class DNSExtensionNestedImpl<N> extends DNSFluentImpl<ClusterOperatorStatusFluent.DNSExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DNSExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DNSExtensionNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.DNSBuilder(this);
    }
    io.fabric8.openshift.api.model.DNSBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endDNSExtension() {
      return and();
    }
    
  }
  class ImageStreamImportExtensionNestedImpl<N> extends ImageStreamImportFluentImpl<ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamImportExtensionNestedImpl(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamImportBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamImportExtension() {
      return and();
    }
    
  }
  class ProxyExtensionNestedImpl<N> extends ProxyFluentImpl<ClusterOperatorStatusFluent.ProxyExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProxyExtensionNestedImpl(io.fabric8.openshift.api.model.Proxy item) {
      this.builder = new ProxyBuilder(this, item);
    }
    ProxyExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProxyBuilder(this);
    }
    io.fabric8.openshift.api.model.ProxyBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endProxyExtension() {
      return and();
    }
    
  }
  class ProjectExtensionNestedImpl<N> extends ProjectFluentImpl<ClusterOperatorStatusFluent.ProjectExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectExtensionNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProjectBuilder(this);
    }
    io.fabric8.openshift.api.model.ProjectBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endProjectExtension() {
      return and();
    }
    
  }
  class ClusterOperatorExtensionNestedImpl<N> extends ClusterOperatorFluentImpl<ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterOperatorExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterOperator item) {
      this.builder = new ClusterOperatorBuilder(this, item);
    }
    ClusterOperatorExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterOperatorBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterOperatorExtension() {
      return and();
    }
    
  }
  class BuildConfigExtensionNestedImpl<N> extends BuildConfigFluentImpl<ClusterOperatorStatusFluent.BuildConfigExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildConfigExtensionNestedImpl(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildConfigBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBuildConfigExtension() {
      return and();
    }
    
  }
  class HelmChartRepositoryExtensionNestedImpl<N> extends HelmChartRepositoryFluentImpl<ClusterOperatorStatusFluent.HelmChartRepositoryExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HelmChartRepositoryExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HelmChartRepositoryExtensionNestedImpl(io.fabric8.openshift.api.model.HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(this);
    }
    io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endHelmChartRepositoryExtension() {
      return and();
    }
    
  }
  class InfrastructureExtensionNestedImpl<N> extends InfrastructureFluentImpl<ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InfrastructureExtensionNestedImpl(Infrastructure item) {
      this.builder = new InfrastructureBuilder(this, item);
    }
    InfrastructureExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(this);
    }
    io.fabric8.openshift.api.model.InfrastructureBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endInfrastructureExtension() {
      return and();
    }
    
  }
  class SchedulerExtensionNestedImpl<N> extends SchedulerFluentImpl<ClusterOperatorStatusFluent.SchedulerExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SchedulerExtensionNestedImpl(io.fabric8.openshift.api.model.Scheduler item) {
      this.builder = new SchedulerBuilder(this, item);
    }
    SchedulerExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SchedulerBuilder(this);
    }
    io.fabric8.openshift.api.model.SchedulerBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endSchedulerExtension() {
      return and();
    }
    
  }
  class RangeAllocationExtensionNestedImpl<N> extends RangeAllocationFluentImpl<ClusterOperatorStatusFluent.RangeAllocationExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RangeAllocationExtensionNestedImpl(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(this);
    }
    io.fabric8.openshift.api.model.RangeAllocationBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRangeAllocationExtension() {
      return and();
    }
    
  }
  class RouteExtensionNestedImpl<N> extends RouteFluentImpl<ClusterOperatorStatusFluent.RouteExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RouteExtensionNestedImpl(io.fabric8.openshift.api.model.Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RouteBuilder(this);
    }
    io.fabric8.openshift.api.model.RouteBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRouteExtension() {
      return and();
    }
    
  }
  class ClusterNetworkExtensionNestedImpl<N> extends ClusterNetworkFluentImpl<ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterNetworkExtensionNestedImpl(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterNetworkBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterNetworkExtension() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenExtensionNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAuthorizeTokenExtensionNestedImpl(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthAuthorizeTokenExtension() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenExtensionNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<ClusterOperatorStatusFluent.UserOAuthAccessTokenExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserOAuthAccessTokenExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserOAuthAccessTokenExtensionNestedImpl(io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endUserOAuthAccessTokenExtension() {
      return and();
    }
    
  }
  class IngressExtensionNestedImpl<N> extends IngressFluentImpl<ClusterOperatorStatusFluent.IngressExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressExtensionNestedImpl(Ingress item) {
      this.builder = new IngressBuilder(this, item);
    }
    IngressExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.IngressBuilder(this);
    }
    io.fabric8.openshift.api.model.IngressBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endIngressExtension() {
      return and();
    }
    
  }
  class OAuthExtensionNestedImpl<N> extends OAuthFluentImpl<ClusterOperatorStatusFluent.OAuthExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthExtensionNestedImpl(io.fabric8.openshift.api.model.OAuth item) {
      this.builder = new OAuthBuilder(this, item);
    }
    OAuthExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthExtension() {
      return and();
    }
    
  }
  class OperatorHubExtensionNestedImpl<N> extends OperatorHubFluentImpl<ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OperatorHubExtensionNestedImpl(io.fabric8.openshift.api.model.OperatorHub item) {
      this.builder = new OperatorHubBuilder(this, item);
    }
    OperatorHubExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(this);
    }
    io.fabric8.openshift.api.model.OperatorHubBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOperatorHubExtension() {
      return and();
    }
    
  }
  class ClusterRoleBindingExtensionNestedImpl<N> extends ClusterRoleBindingFluentImpl<ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterRoleBindingExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterRoleBindingExtension() {
      return and();
    }
    
  }
  class ClusterResourceQuotaExtensionNestedImpl<N> extends ClusterResourceQuotaFluentImpl<ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterResourceQuotaExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterResourceQuotaExtension() {
      return and();
    }
    
  }
  class ProjectRequestExtensionNestedImpl<N> extends ProjectRequestFluentImpl<ClusterOperatorStatusFluent.ProjectRequestExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectRequestExtensionNestedImpl(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(this);
    }
    io.fabric8.openshift.api.model.ProjectRequestBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endProjectRequestExtension() {
      return and();
    }
    
  }
  class TemplateExtensionNestedImpl<N> extends TemplateFluentImpl<ClusterOperatorStatusFluent.TemplateExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateExtensionNestedImpl(io.fabric8.openshift.api.model.Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TemplateBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endTemplateExtension() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationExtensionNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthClientAuthorizationExtensionNestedImpl(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthClientAuthorizationExtension() {
      return and();
    }
    
  }
  class ClusterRoleExtensionNestedImpl<N> extends ClusterRoleFluentImpl<ClusterOperatorStatusFluent.ClusterRoleExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterRoleExtensionNestedImpl(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterRoleBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterRoleExtension() {
      return and();
    }
    
  }
  class AuthenticationExtensionNestedImpl<N> extends AuthenticationFluentImpl<ClusterOperatorStatusFluent.AuthenticationExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AuthenticationExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AuthenticationExtensionNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(this);
    }
    io.fabric8.openshift.api.model.AuthenticationBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endAuthenticationExtension() {
      return and();
    }
    
  }
  class ImageTagExtensionNestedImpl<N> extends ImageTagFluentImpl<ClusterOperatorStatusFluent.ImageTagExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageTagExtensionNestedImpl(io.fabric8.openshift.api.model.ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageTagBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageTagBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageTagExtension() {
      return and();
    }
    
  }
  class OAuthAccessTokenExtensionNestedImpl<N> extends OAuthAccessTokenFluentImpl<ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAccessTokenExtensionNestedImpl(io.fabric8.openshift.api.model.OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthAccessTokenExtension() {
      return and();
    }
    
  }
  class DeploymentConfigExtensionNestedImpl<N> extends DeploymentConfigFluentImpl<ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DeploymentConfigExtensionNestedImpl(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.DeploymentConfigBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endDeploymentConfigExtension() {
      return and();
    }
    
  }
  class RoleBindingExtensionNestedImpl<N> extends RoleBindingFluentImpl<ClusterOperatorStatusFluent.RoleBindingExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleBindingExtensionNestedImpl(io.fabric8.openshift.api.model.RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBindingBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRoleBindingExtension() {
      return and();
    }
    
  }
  class ImageExtensionNestedImpl<N> extends ImageFluentImpl<ClusterOperatorStatusFluent.ImageExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageExtensionNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageExtension() {
      return and();
    }
    
  }
  class APIServerExtensionNestedImpl<N> extends APIServerFluentImpl<ClusterOperatorStatusFluent.APIServerExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIServerExtensionNestedImpl(APIServer item) {
      this.builder = new APIServerBuilder(this, item);
    }
    APIServerExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.APIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.APIServerBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServerExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimExtensionNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimExtensionNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimExtensionNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimExtension() {
      return and();
    }
    
  }
  class ImageStreamMappingExtensionNestedImpl<N> extends ImageStreamMappingFluentImpl<ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamMappingExtensionNestedImpl(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamMappingExtension() {
      return and();
    }
    
  }
  class RoleExtensionNestedImpl<N> extends RoleFluentImpl<ClusterOperatorStatusFluent.RoleExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleExtensionNestedImpl(io.fabric8.openshift.api.model.Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRoleExtension() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceExtensionNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<ClusterOperatorStatusFluent.BrokerTemplateInstanceExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BrokerTemplateInstanceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BrokerTemplateInstanceExtensionNestedImpl(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(this);
    }
    io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBrokerTemplateInstanceExtension() {
      return and();
    }
    
  }
  class FeatureGateExtensionNestedImpl<N> extends FeatureGateFluentImpl<ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FeatureGateExtensionNestedImpl(FeatureGate item) {
      this.builder = new FeatureGateBuilder(this, item);
    }
    FeatureGateExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(this);
    }
    io.fabric8.openshift.api.model.FeatureGateBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endFeatureGateExtension() {
      return and();
    }
    
  }
  class UserExtensionNestedImpl<N> extends UserFluentImpl<ClusterOperatorStatusFluent.UserExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserExtensionNestedImpl(io.fabric8.openshift.api.model.User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserBuilder(this);
    }
    io.fabric8.openshift.api.model.UserBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endUserExtension() {
      return and();
    }
    
  }
  class ImageStreamImageExtensionNestedImpl<N> extends ImageStreamImageFluentImpl<ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamImageExtensionNestedImpl(io.fabric8.openshift.api.model.ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamImageBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamImageExtension() {
      return and();
    }
    
  }
  class TemplateInstanceExtensionNestedImpl<N> extends TemplateInstanceFluentImpl<ClusterOperatorStatusFluent.TemplateInstanceExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateInstanceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateInstanceExtensionNestedImpl(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateInstanceBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endTemplateInstanceExtension() {
      return and();
    }
    
  }
  class BuildExtensionNestedImpl<N> extends BuildFluentImpl<ClusterOperatorStatusFluent.BuildExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildExtensionNestedImpl(io.fabric8.openshift.api.model.Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBuildExtension() {
      return and();
    }
    
  }
  class RoleBindingRestrictionExtensionNestedImpl<N> extends RoleBindingRestrictionFluentImpl<ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleBindingRestrictionExtensionNestedImpl(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRoleBindingRestrictionExtension() {
      return and();
    }
    
  }
  class ImageStreamTagExtensionNestedImpl<N> extends ImageStreamTagFluentImpl<ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamTagExtensionNestedImpl(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamTagBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamTagExtension() {
      return and();
    }
    
  }
  class GroupExtensionNestedImpl<N> extends GroupFluentImpl<ClusterOperatorStatusFluent.GroupExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GroupExtensionNestedImpl(io.fabric8.openshift.api.model.Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.GroupBuilder(this);
    }
    io.fabric8.openshift.api.model.GroupBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endGroupExtension() {
      return and();
    }
    
  }
  class ImageSignatureExtensionNestedImpl<N> extends ImageSignatureFluentImpl<ClusterOperatorStatusFluent.ImageSignatureExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageSignatureExtensionNestedImpl(io.fabric8.openshift.api.model.ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageSignatureExtension() {
      return and();
    }
    
  }
  class HostSubnetExtensionNestedImpl<N> extends HostSubnetFluentImpl<ClusterOperatorStatusFluent.HostSubnetExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HostSubnetExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HostSubnetExtensionNestedImpl(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(this);
    }
    io.fabric8.openshift.api.model.HostSubnetBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endHostSubnetExtension() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaExtensionNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AppliedClusterResourceQuotaExtensionNestedImpl(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(this);
    }
    io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endAppliedClusterResourceQuotaExtension() {
      return and();
    }
    
  }
  class SecurityContextConstraintsExtensionNestedImpl<N> extends SecurityContextConstraintsFluentImpl<ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecurityContextConstraintsExtensionNestedImpl(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(this);
    }
    io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endSecurityContextConstraintsExtension() {
      return and();
    }
    
  }
  class ConsoleExtensionNestedImpl<N> extends ConsoleFluentImpl<ClusterOperatorStatusFluent.ConsoleExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConsoleExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConsoleExtensionNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ConsoleBuilder(this);
    }
    io.fabric8.openshift.api.model.ConsoleBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endConsoleExtension() {
      return and();
    }
    
  }
  class BuildRequestExtensionNestedImpl<N> extends BuildRequestFluentImpl<ClusterOperatorStatusFluent.BuildRequestExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildRequestExtensionNestedImpl(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildRequestBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBuildRequestExtension() {
      return and();
    }
    
  }
  class EgressNetworkPolicyExtensionNestedImpl<N> extends EgressNetworkPolicyFluentImpl<ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EgressNetworkPolicyExtensionNestedImpl(io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endEgressNetworkPolicyExtension() {
      return and();
    }
    
  }
  class NetNamespaceExtensionNestedImpl<N> extends NetNamespaceFluentImpl<ClusterOperatorStatusFluent.NetNamespaceExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetNamespaceExtensionNestedImpl(io.fabric8.openshift.api.model.NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(this);
    }
    io.fabric8.openshift.api.model.NetNamespaceBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endNetNamespaceExtension() {
      return and();
    }
    
  }
  class UserIdentityMappingExtensionNestedImpl<N> extends UserIdentityMappingFluentImpl<ClusterOperatorStatusFluent.UserIdentityMappingExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserIdentityMappingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserIdentityMappingExtensionNestedImpl(io.fabric8.openshift.api.model.UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(this);
    }
    io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endUserIdentityMappingExtension() {
      return and();
    }
    
  }
  class ImageStreamExtensionNestedImpl<N> extends ImageStreamFluentImpl<ClusterOperatorStatusFluent.ImageStreamExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamExtensionNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamExtension() {
      return and();
    }
    
  }
  class NetworkExtensionNestedImpl<N> extends NetworkFluentImpl<ClusterOperatorStatusFluent.NetworkExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetworkExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetworkExtensionNestedImpl(io.fabric8.openshift.api.model.Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.NetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.NetworkBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endNetworkExtension() {
      return and();
    }
    
  }
  class OAuthClientExtensionNestedImpl<N> extends OAuthClientFluentImpl<ClusterOperatorStatusFluent.OAuthClientExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthClientExtensionNestedImpl(io.fabric8.openshift.api.model.OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthClientBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthClientExtension() {
      return and();
    }
    
  }
  class IdentityExtensionNestedImpl<N> extends IdentityFluentImpl<ClusterOperatorStatusFluent.IdentityExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IdentityExtensionNestedImpl(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.IdentityBuilder(this);
    }
    io.fabric8.openshift.api.model.IdentityBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endIdentityExtension() {
      return and();
    }
    
  }
  class RelatedObjectsNestedImpl<N> extends ObjectReferenceFluentImpl<ClusterOperatorStatusFluent.RelatedObjectsNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RelatedObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    RelatedObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToRelatedObjects(index,builder.build());
    }
    public N endRelatedObject() {
      return and();
    }
    
  }
  class VersionsNestedImpl<N> extends OperandVersionFluentImpl<ClusterOperatorStatusFluent.VersionsNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VersionsNestedImpl(java.lang.Integer index,OperandVersion item) {
      this.index = index;
      this.builder = new OperandVersionBuilder(this, item);
    }
    VersionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(this);
    }
    io.fabric8.openshift.api.model.OperandVersionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToVersions(index,builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}