package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOperatorStatusConditionBuilder extends ClusterOperatorStatusConditionFluentImpl<ClusterOperatorStatusConditionBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition,io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>{
  public ClusterOperatorStatusConditionBuilder() {
    this(false);
  }
  public ClusterOperatorStatusConditionBuilder(Boolean validationEnabled) {
    this(new ClusterOperatorStatusCondition(), validationEnabled);
  }
  public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOperatorStatusConditionBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterOperatorStatusCondition(), validationEnabled);
  }
  public ClusterOperatorStatusConditionBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusConditionFluent<?> fluent,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterOperatorStatusConditionBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusConditionFluent<?> fluent,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterOperatorStatusConditionBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition instance) {
    this(instance,false);
  }
  public ClusterOperatorStatusConditionBuilder(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterOperatorStatusConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition build() {
    ClusterOperatorStatusCondition buildable = new ClusterOperatorStatusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}