package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildVolumeMountBuilder extends BuildVolumeMountFluentImpl<BuildVolumeMountBuilder> implements VisitableBuilder<BuildVolumeMount,io.fabric8.openshift.api.model.BuildVolumeMountBuilder>{
  public BuildVolumeMountBuilder() {
    this(false);
  }
  public BuildVolumeMountBuilder(Boolean validationEnabled) {
    this(new BuildVolumeMount(), validationEnabled);
  }
  public BuildVolumeMountBuilder(io.fabric8.openshift.api.model.BuildVolumeMountFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildVolumeMountBuilder(io.fabric8.openshift.api.model.BuildVolumeMountFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildVolumeMount(), validationEnabled);
  }
  public BuildVolumeMountBuilder(io.fabric8.openshift.api.model.BuildVolumeMountFluent<?> fluent,io.fabric8.openshift.api.model.BuildVolumeMount instance) {
    this(fluent, instance, false);
  }
  public BuildVolumeMountBuilder(io.fabric8.openshift.api.model.BuildVolumeMountFluent<?> fluent,io.fabric8.openshift.api.model.BuildVolumeMount instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestinationPath(instance.getDestinationPath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildVolumeMountBuilder(io.fabric8.openshift.api.model.BuildVolumeMount instance) {
    this(instance,false);
  }
  public BuildVolumeMountBuilder(io.fabric8.openshift.api.model.BuildVolumeMount instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestinationPath(instance.getDestinationPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildVolumeMountFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildVolumeMount build() {
    BuildVolumeMount buildable = new BuildVolumeMount(fluent.getDestinationPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}