package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildSourceFluentImpl<A extends BuildSourceFluent<A>> extends BaseFluent<A> implements BuildSourceFluent<A>{
  public BuildSourceFluentImpl() {
  }
  public BuildSourceFluentImpl(io.fabric8.openshift.api.model.BuildSource instance) {
    this.withBinary(instance.getBinary()); 
    this.withConfigMaps(instance.getConfigMaps()); 
    this.withContextDir(instance.getContextDir()); 
    this.withDockerfile(instance.getDockerfile()); 
    this.withGit(instance.getGit()); 
    this.withImages(instance.getImages()); 
    this.withSecrets(instance.getSecrets()); 
    this.withSourceSecret(instance.getSourceSecret()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private BinaryBuildSourceBuilder binary;
  private ArrayList<ConfigMapBuildSourceBuilder> configMaps = new java.util.ArrayList<ConfigMapBuildSourceBuilder>();
  private String contextDir;
  private java.lang.String dockerfile;
  private GitBuildSourceBuilder git;
  private java.util.ArrayList<ImageSourceBuilder> images = new java.util.ArrayList<ImageSourceBuilder>();
  private java.util.ArrayList<SecretBuildSourceBuilder> secrets = new java.util.ArrayList<SecretBuildSourceBuilder>();
  private LocalObjectReferenceBuilder sourceSecret;
  private java.lang.String type;
  private Map<java.lang.String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildBinary instead.
   * @return The buildable object.
   */
  @Deprecated
  public BinaryBuildSource getBinary() {
    return this.binary!=null ?this.binary.build():null;
  }
  public io.fabric8.openshift.api.model.BinaryBuildSource buildBinary() {
    return this.binary!=null ?this.binary.build():null;
  }
  public A withBinary(io.fabric8.openshift.api.model.BinaryBuildSource binary) {
    _visitables.get("binary").remove(this.binary);
    if (binary!=null){ this.binary= new io.fabric8.openshift.api.model.BinaryBuildSourceBuilder(binary); _visitables.get("binary").add(this.binary);} return (A) this;
  }
  public Boolean hasBinary() {
    return this.binary != null;
  }
  public A withNewBinary(java.lang.String asFile) {
    return (A)withBinary(new BinaryBuildSource(asFile));
  }
  public BuildSourceFluent.BinaryNested<A> withNewBinary() {
    return new BuildSourceFluentImpl.BinaryNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.BinaryNested<A> withNewBinaryLike(io.fabric8.openshift.api.model.BinaryBuildSource item) {
    return new BuildSourceFluentImpl.BinaryNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.BinaryNested<A> editBinary() {
    return withNewBinaryLike(getBinary());
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.BinaryNested<A> editOrNewBinary() {
    return withNewBinaryLike(getBinary() != null ? getBinary(): new io.fabric8.openshift.api.model.BinaryBuildSourceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.BinaryNested<A> editOrNewBinaryLike(io.fabric8.openshift.api.model.BinaryBuildSource item) {
    return withNewBinaryLike(getBinary() != null ? getBinary(): item);
  }
  public A addToConfigMaps(Integer index,io.fabric8.openshift.api.model.ConfigMapBuildSource item) {
    if (this.configMaps == null) {this.configMaps = new java.util.ArrayList<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder>();}
    io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder builder = new io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").add(index >= 0 ? index : _visitables.get("configMaps").size(), builder);this.configMaps.add(index >= 0 ? index : configMaps.size(), builder); return (A)this;
  }
  public A setToConfigMaps(java.lang.Integer index,io.fabric8.openshift.api.model.ConfigMapBuildSource item) {
    if (this.configMaps == null) {this.configMaps = new java.util.ArrayList<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder>();}
    io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder builder = new io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder(item);
    if (index < 0 || index >= _visitables.get("configMaps").size()) { _visitables.get("configMaps").add(builder); } else { _visitables.get("configMaps").set(index, builder);}
    if (index < 0 || index >= configMaps.size()) { configMaps.add(builder); } else { configMaps.set(index, builder);}
     return (A)this;
  }
  public A addToConfigMaps(io.fabric8.openshift.api.model.ConfigMapBuildSource... items) {
    if (this.configMaps == null) {this.configMaps = new java.util.ArrayList<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder>();}
    for (io.fabric8.openshift.api.model.ConfigMapBuildSource item : items) {io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder builder = new io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").add(builder);this.configMaps.add(builder);} return (A)this;
  }
  public A addAllToConfigMaps(Collection<io.fabric8.openshift.api.model.ConfigMapBuildSource> items) {
    if (this.configMaps == null) {this.configMaps = new java.util.ArrayList<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder>();}
    for (io.fabric8.openshift.api.model.ConfigMapBuildSource item : items) {io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder builder = new io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").add(builder);this.configMaps.add(builder);} return (A)this;
  }
  public A removeFromConfigMaps(io.fabric8.openshift.api.model.ConfigMapBuildSource... items) {
    for (io.fabric8.openshift.api.model.ConfigMapBuildSource item : items) {io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder builder = new io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").remove(builder);if (this.configMaps != null) {this.configMaps.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfigMaps(java.util.Collection<io.fabric8.openshift.api.model.ConfigMapBuildSource> items) {
    for (io.fabric8.openshift.api.model.ConfigMapBuildSource item : items) {io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder builder = new io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").remove(builder);if (this.configMaps != null) {this.configMaps.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfigMaps(Predicate<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder> predicate) {
    if (configMaps == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder> each = configMaps.iterator();
    final List visitables = _visitables.get("configMaps");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMaps instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.openshift.api.model.ConfigMapBuildSource> getConfigMaps() {
    return configMaps != null ? build(configMaps) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ConfigMapBuildSource> buildConfigMaps() {
    return configMaps != null ? build(configMaps) : null;
  }
  public io.fabric8.openshift.api.model.ConfigMapBuildSource buildConfigMap(java.lang.Integer index) {
    return this.configMaps.get(index).build();
  }
  public io.fabric8.openshift.api.model.ConfigMapBuildSource buildFirstConfigMap() {
    return this.configMaps.get(0).build();
  }
  public io.fabric8.openshift.api.model.ConfigMapBuildSource buildLastConfigMap() {
    return this.configMaps.get(configMaps.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ConfigMapBuildSource buildMatchingConfigMap(java.util.function.Predicate<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder item: configMaps) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingConfigMap(java.util.function.Predicate<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder item: configMaps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfigMaps(java.util.List<io.fabric8.openshift.api.model.ConfigMapBuildSource> configMaps) {
    if (this.configMaps != null) { _visitables.get("configMaps").removeAll(this.configMaps);}
    if (configMaps != null) {this.configMaps = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ConfigMapBuildSource item : configMaps){this.addToConfigMaps(item);}} else { this.configMaps = null;} return (A) this;
  }
  public A withConfigMaps(io.fabric8.openshift.api.model.ConfigMapBuildSource... configMaps) {
    if (this.configMaps != null) {this.configMaps.clear();}
    if (configMaps != null) {for (io.fabric8.openshift.api.model.ConfigMapBuildSource item :configMaps){ this.addToConfigMaps(item);}} return (A) this;
  }
  public java.lang.Boolean hasConfigMaps() {
    return configMaps != null && !configMaps.isEmpty();
  }
  public BuildSourceFluent.ConfigMapsNested<A> addNewConfigMap() {
    return new BuildSourceFluentImpl.ConfigMapsNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ConfigMapsNested<A> addNewConfigMapLike(io.fabric8.openshift.api.model.ConfigMapBuildSource item) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentImpl.ConfigMapsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ConfigMapsNested<A> setNewConfigMapLike(java.lang.Integer index,io.fabric8.openshift.api.model.ConfigMapBuildSource item) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentImpl.ConfigMapsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ConfigMapsNested<A> editConfigMap(java.lang.Integer index) {
    if (configMaps.size() <= index) throw new RuntimeException("Can't edit configMaps. Index exceeds size.");
    return setNewConfigMapLike(index, buildConfigMap(index));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ConfigMapsNested<A> editFirstConfigMap() {
    if (configMaps.size() == 0) throw new RuntimeException("Can't edit first configMaps. The list is empty.");
    return setNewConfigMapLike(0, buildConfigMap(0));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ConfigMapsNested<A> editLastConfigMap() {
    int index = configMaps.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configMaps. The list is empty.");
    return setNewConfigMapLike(index, buildConfigMap(index));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ConfigMapsNested<A> editMatchingConfigMap(java.util.function.Predicate<io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configMaps.size();i++) { 
    if (predicate.test(configMaps.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configMaps. No match found.");
    return setNewConfigMapLike(index, buildConfigMap(index));
  }
  public java.lang.String getContextDir() {
    return this.contextDir;
  }
  public A withContextDir(java.lang.String contextDir) {
    this.contextDir=contextDir; return (A) this;
  }
  public java.lang.Boolean hasContextDir() {
    return this.contextDir != null;
  }
  public java.lang.String getDockerfile() {
    return this.dockerfile;
  }
  public A withDockerfile(java.lang.String dockerfile) {
    this.dockerfile=dockerfile; return (A) this;
  }
  public java.lang.Boolean hasDockerfile() {
    return this.dockerfile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildGit instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.GitBuildSource getGit() {
    return this.git!=null ?this.git.build():null;
  }
  public io.fabric8.openshift.api.model.GitBuildSource buildGit() {
    return this.git!=null ?this.git.build():null;
  }
  public A withGit(io.fabric8.openshift.api.model.GitBuildSource git) {
    _visitables.get("git").remove(this.git);
    if (git!=null){ this.git= new GitBuildSourceBuilder(git); _visitables.get("git").add(this.git);} return (A) this;
  }
  public java.lang.Boolean hasGit() {
    return this.git != null;
  }
  public A withNewGit(java.lang.String httpProxy,java.lang.String httpsProxy,java.lang.String noProxy,java.lang.String ref,java.lang.String uri) {
    return (A)withGit(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
  }
  public BuildSourceFluent.GitNested<A> withNewGit() {
    return new BuildSourceFluentImpl.GitNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.GitNested<A> withNewGitLike(io.fabric8.openshift.api.model.GitBuildSource item) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentImpl.GitNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.GitNested<A> editGit() {
    return withNewGitLike(getGit());
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.GitNested<A> editOrNewGit() {
    return withNewGitLike(getGit() != null ? getGit(): new io.fabric8.openshift.api.model.GitBuildSourceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.GitNested<A> editOrNewGitLike(io.fabric8.openshift.api.model.GitBuildSource item) {
    return withNewGitLike(getGit() != null ? getGit(): item);
  }
  public A addToImages(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSource item) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourceBuilder>();}
    io.fabric8.openshift.api.model.ImageSourceBuilder builder = new io.fabric8.openshift.api.model.ImageSourceBuilder(item);_visitables.get("images").add(index >= 0 ? index : _visitables.get("images").size(), builder);this.images.add(index >= 0 ? index : images.size(), builder); return (A)this;
  }
  public A setToImages(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSource item) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourceBuilder>();}
    io.fabric8.openshift.api.model.ImageSourceBuilder builder = new io.fabric8.openshift.api.model.ImageSourceBuilder(item);
    if (index < 0 || index >= _visitables.get("images").size()) { _visitables.get("images").add(builder); } else { _visitables.get("images").set(index, builder);}
    if (index < 0 || index >= images.size()) { images.add(builder); } else { images.set(index, builder);}
     return (A)this;
  }
  public A addToImages(io.fabric8.openshift.api.model.ImageSource... items) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourceBuilder>();}
    for (io.fabric8.openshift.api.model.ImageSource item : items) {io.fabric8.openshift.api.model.ImageSourceBuilder builder = new io.fabric8.openshift.api.model.ImageSourceBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(java.util.Collection<io.fabric8.openshift.api.model.ImageSource> items) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourceBuilder>();}
    for (io.fabric8.openshift.api.model.ImageSource item : items) {io.fabric8.openshift.api.model.ImageSourceBuilder builder = new io.fabric8.openshift.api.model.ImageSourceBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.openshift.api.model.ImageSource... items) {
    for (io.fabric8.openshift.api.model.ImageSource item : items) {io.fabric8.openshift.api.model.ImageSourceBuilder builder = new io.fabric8.openshift.api.model.ImageSourceBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeAllFromImages(java.util.Collection<io.fabric8.openshift.api.model.ImageSource> items) {
    for (io.fabric8.openshift.api.model.ImageSource item : items) {io.fabric8.openshift.api.model.ImageSourceBuilder builder = new io.fabric8.openshift.api.model.ImageSourceBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImages(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSourceBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ImageSourceBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ImageSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ImageSource> getImages() {
    return images != null ? build(images) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ImageSource> buildImages() {
    return images != null ? build(images) : null;
  }
  public io.fabric8.openshift.api.model.ImageSource buildImage(java.lang.Integer index) {
    return this.images.get(index).build();
  }
  public io.fabric8.openshift.api.model.ImageSource buildFirstImage() {
    return this.images.get(0).build();
  }
  public io.fabric8.openshift.api.model.ImageSource buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ImageSource buildMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSourceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageSourceBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSourceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageSourceBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(java.util.List<io.fabric8.openshift.api.model.ImageSource> images) {
    if (this.images != null) { _visitables.get("images").removeAll(this.images);}
    if (images != null) {this.images = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ImageSource item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.openshift.api.model.ImageSource... images) {
    if (this.images != null) {this.images.clear();}
    if (images != null) {for (io.fabric8.openshift.api.model.ImageSource item :images){ this.addToImages(item);}} return (A) this;
  }
  public java.lang.Boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public BuildSourceFluent.ImagesNested<A> addNewImage() {
    return new BuildSourceFluentImpl.ImagesNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ImagesNested<A> addNewImageLike(io.fabric8.openshift.api.model.ImageSource item) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentImpl.ImagesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ImagesNested<A> setNewImageLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSource item) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentImpl.ImagesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ImagesNested<A> editImage(java.lang.Integer index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.ImagesNested<A> editMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  public A addToSecrets(java.lang.Integer index,io.fabric8.openshift.api.model.SecretBuildSource item) {
    if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretBuildSourceBuilder>();}
    io.fabric8.openshift.api.model.SecretBuildSourceBuilder builder = new io.fabric8.openshift.api.model.SecretBuildSourceBuilder(item);_visitables.get("secrets").add(index >= 0 ? index : _visitables.get("secrets").size(), builder);this.secrets.add(index >= 0 ? index : secrets.size(), builder); return (A)this;
  }
  public A setToSecrets(java.lang.Integer index,io.fabric8.openshift.api.model.SecretBuildSource item) {
    if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretBuildSourceBuilder>();}
    io.fabric8.openshift.api.model.SecretBuildSourceBuilder builder = new io.fabric8.openshift.api.model.SecretBuildSourceBuilder(item);
    if (index < 0 || index >= _visitables.get("secrets").size()) { _visitables.get("secrets").add(builder); } else { _visitables.get("secrets").set(index, builder);}
    if (index < 0 || index >= secrets.size()) { secrets.add(builder); } else { secrets.set(index, builder);}
     return (A)this;
  }
  public A addToSecrets(io.fabric8.openshift.api.model.SecretBuildSource... items) {
    if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretBuildSourceBuilder>();}
    for (io.fabric8.openshift.api.model.SecretBuildSource item : items) {io.fabric8.openshift.api.model.SecretBuildSourceBuilder builder = new io.fabric8.openshift.api.model.SecretBuildSourceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  public A addAllToSecrets(java.util.Collection<io.fabric8.openshift.api.model.SecretBuildSource> items) {
    if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.openshift.api.model.SecretBuildSourceBuilder>();}
    for (io.fabric8.openshift.api.model.SecretBuildSource item : items) {io.fabric8.openshift.api.model.SecretBuildSourceBuilder builder = new io.fabric8.openshift.api.model.SecretBuildSourceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  public A removeFromSecrets(io.fabric8.openshift.api.model.SecretBuildSource... items) {
    for (io.fabric8.openshift.api.model.SecretBuildSource item : items) {io.fabric8.openshift.api.model.SecretBuildSourceBuilder builder = new io.fabric8.openshift.api.model.SecretBuildSourceBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
  }
  public A removeAllFromSecrets(java.util.Collection<io.fabric8.openshift.api.model.SecretBuildSource> items) {
    for (io.fabric8.openshift.api.model.SecretBuildSource item : items) {io.fabric8.openshift.api.model.SecretBuildSourceBuilder builder = new io.fabric8.openshift.api.model.SecretBuildSourceBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSecrets(java.util.function.Predicate<io.fabric8.openshift.api.model.SecretBuildSourceBuilder> predicate) {
    if (secrets == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.SecretBuildSourceBuilder> each = secrets.iterator();
    final List visitables = _visitables.get("secrets");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.SecretBuildSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSecrets instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.SecretBuildSource> getSecrets() {
    return secrets != null ? build(secrets) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.SecretBuildSource> buildSecrets() {
    return secrets != null ? build(secrets) : null;
  }
  public io.fabric8.openshift.api.model.SecretBuildSource buildSecret(java.lang.Integer index) {
    return this.secrets.get(index).build();
  }
  public io.fabric8.openshift.api.model.SecretBuildSource buildFirstSecret() {
    return this.secrets.get(0).build();
  }
  public io.fabric8.openshift.api.model.SecretBuildSource buildLastSecret() {
    return this.secrets.get(secrets.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.SecretBuildSource buildMatchingSecret(java.util.function.Predicate<io.fabric8.openshift.api.model.SecretBuildSourceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.SecretBuildSourceBuilder item: secrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingSecret(java.util.function.Predicate<io.fabric8.openshift.api.model.SecretBuildSourceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.SecretBuildSourceBuilder item: secrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSecrets(java.util.List<io.fabric8.openshift.api.model.SecretBuildSource> secrets) {
    if (this.secrets != null) { _visitables.get("secrets").removeAll(this.secrets);}
    if (secrets != null) {this.secrets = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.SecretBuildSource item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
  }
  public A withSecrets(io.fabric8.openshift.api.model.SecretBuildSource... secrets) {
    if (this.secrets != null) {this.secrets.clear();}
    if (secrets != null) {for (io.fabric8.openshift.api.model.SecretBuildSource item :secrets){ this.addToSecrets(item);}} return (A) this;
  }
  public java.lang.Boolean hasSecrets() {
    return secrets != null && !secrets.isEmpty();
  }
  public BuildSourceFluent.SecretsNested<A> addNewSecret() {
    return new BuildSourceFluentImpl.SecretsNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SecretsNested<A> addNewSecretLike(io.fabric8.openshift.api.model.SecretBuildSource item) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentImpl.SecretsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SecretsNested<A> setNewSecretLike(java.lang.Integer index,io.fabric8.openshift.api.model.SecretBuildSource item) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentImpl.SecretsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SecretsNested<A> editSecret(java.lang.Integer index) {
    if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
    return setNewSecretLike(index, buildSecret(index));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SecretsNested<A> editFirstSecret() {
    if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
    return setNewSecretLike(0, buildSecret(0));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SecretsNested<A> editLastSecret() {
    int index = secrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
    return setNewSecretLike(index, buildSecret(index));
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SecretsNested<A> editMatchingSecret(java.util.function.Predicate<io.fabric8.openshift.api.model.SecretBuildSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secrets.size();i++) { 
    if (predicate.test(secrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSourceSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LocalObjectReference getSourceSecret() {
    return this.sourceSecret!=null ?this.sourceSecret.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildSourceSecret() {
    return this.sourceSecret!=null ?this.sourceSecret.build():null;
  }
  public A withSourceSecret(io.fabric8.kubernetes.api.model.LocalObjectReference sourceSecret) {
    _visitables.get("sourceSecret").remove(this.sourceSecret);
    if (sourceSecret!=null){ this.sourceSecret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(sourceSecret); _visitables.get("sourceSecret").add(this.sourceSecret);} return (A) this;
  }
  public java.lang.Boolean hasSourceSecret() {
    return this.sourceSecret != null;
  }
  public A withNewSourceSecret(java.lang.String name) {
    return (A)withSourceSecret(new LocalObjectReference(name));
  }
  public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecret() {
    return new BuildSourceFluentImpl.SourceSecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SourceSecretNested<A> withNewSourceSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentImpl.SourceSecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SourceSecretNested<A> editSourceSecret() {
    return withNewSourceSecretLike(getSourceSecret());
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SourceSecretNested<A> editOrNewSourceSecret() {
    return withNewSourceSecretLike(getSourceSecret() != null ? getSourceSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildSourceFluent.SourceSecretNested<A> editOrNewSourceSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewSourceSecretLike(getSourceSecret() != null ? getSourceSecret(): item);
  }
  public java.lang.String getType() {
    return this.type;
  }
  public A withType(java.lang.String type) {
    this.type=type; return (A) this;
  }
  public java.lang.Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuildSourceFluentImpl that = (BuildSourceFluentImpl) o;
    if (binary != null ? !binary.equals(that.binary) :that.binary != null) return false;
    if (configMaps != null ? !configMaps.equals(that.configMaps) :that.configMaps != null) return false;
    if (contextDir != null ? !contextDir.equals(that.contextDir) :that.contextDir != null) return false;
    if (dockerfile != null ? !dockerfile.equals(that.dockerfile) :that.dockerfile != null) return false;
    if (git != null ? !git.equals(that.git) :that.git != null) return false;
    if (images != null ? !images.equals(that.images) :that.images != null) return false;
    if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
    if (sourceSecret != null ? !sourceSecret.equals(that.sourceSecret) :that.sourceSecret != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(binary,  configMaps,  contextDir,  dockerfile,  git,  images,  secrets,  sourceSecret,  type,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (binary != null) { sb.append("binary:"); sb.append(binary + ","); }
    if (configMaps != null && !configMaps.isEmpty()) { sb.append("configMaps:"); sb.append(configMaps + ","); }
    if (contextDir != null) { sb.append("contextDir:"); sb.append(contextDir + ","); }
    if (dockerfile != null) { sb.append("dockerfile:"); sb.append(dockerfile + ","); }
    if (git != null) { sb.append("git:"); sb.append(git + ","); }
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets + ","); }
    if (sourceSecret != null) { sb.append("sourceSecret:"); sb.append(sourceSecret + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BinaryNestedImpl<N> extends BinaryBuildSourceFluentImpl<BuildSourceFluent.BinaryNested<N>> implements io.fabric8.openshift.api.model.BuildSourceFluent.BinaryNested<N>,Nested<N>{
    BinaryNestedImpl(io.fabric8.openshift.api.model.BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BinaryBuildSourceBuilder(this);
    }
    io.fabric8.openshift.api.model.BinaryBuildSourceBuilder builder;
    public N and() {
      return (N) BuildSourceFluentImpl.this.withBinary(builder.build());
    }
    public N endBinary() {
      return and();
    }
    
  }
  class ConfigMapsNestedImpl<N> extends ConfigMapBuildSourceFluentImpl<BuildSourceFluent.ConfigMapsNested<N>> implements io.fabric8.openshift.api.model.BuildSourceFluent.ConfigMapsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigMapsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ConfigMapBuildSource item) {
      this.index = index;
      this.builder = new ConfigMapBuildSourceBuilder(this, item);
    }
    ConfigMapsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder(this);
    }
    io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildSourceFluentImpl.this.setToConfigMaps(index,builder.build());
    }
    public N endConfigMap() {
      return and();
    }
    
  }
  class GitNestedImpl<N> extends GitBuildSourceFluentImpl<BuildSourceFluent.GitNested<N>> implements io.fabric8.openshift.api.model.BuildSourceFluent.GitNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GitNestedImpl(io.fabric8.openshift.api.model.GitBuildSource item) {
      this.builder = new GitBuildSourceBuilder(this, item);
    }
    GitNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.GitBuildSourceBuilder(this);
    }
    io.fabric8.openshift.api.model.GitBuildSourceBuilder builder;
    public N and() {
      return (N) BuildSourceFluentImpl.this.withGit(builder.build());
    }
    public N endGit() {
      return and();
    }
    
  }
  class ImagesNestedImpl<N> extends ImageSourceFluentImpl<BuildSourceFluent.ImagesNested<N>> implements io.fabric8.openshift.api.model.BuildSourceFluent.ImagesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImagesNestedImpl(java.lang.Integer index,ImageSource item) {
      this.index = index;
      this.builder = new ImageSourceBuilder(this, item);
    }
    ImagesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageSourceBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageSourceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildSourceFluentImpl.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class SecretsNestedImpl<N> extends SecretBuildSourceFluentImpl<BuildSourceFluent.SecretsNested<N>> implements io.fabric8.openshift.api.model.BuildSourceFluent.SecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecretsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.SecretBuildSource item) {
      this.index = index;
      this.builder = new SecretBuildSourceBuilder(this, item);
    }
    SecretsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.SecretBuildSourceBuilder(this);
    }
    io.fabric8.openshift.api.model.SecretBuildSourceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildSourceFluentImpl.this.setToSecrets(index,builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class SourceSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<BuildSourceFluent.SourceSecretNested<N>> implements io.fabric8.openshift.api.model.BuildSourceFluent.SourceSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SourceSecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
    }
    SourceSecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildSourceFluentImpl.this.withSourceSecret(builder.build());
    }
    public N endSourceSecret() {
      return and();
    }
    
  }
  
}