package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildOutputBuilder extends BuildOutputFluentImpl<BuildOutputBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.BuildOutput,BuildOutputBuilder>{
  public BuildOutputBuilder() {
    this(false);
  }
  public BuildOutputBuilder(Boolean validationEnabled) {
    this(new BuildOutput(), validationEnabled);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildOutput(), validationEnabled);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent,io.fabric8.openshift.api.model.BuildOutput instance) {
    this(fluent, instance, false);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent,io.fabric8.openshift.api.model.BuildOutput instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImageLabels(instance.getImageLabels()); 
    fluent.withPushSecret(instance.getPushSecret()); 
    fluent.withTo(instance.getTo()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutput instance) {
    this(instance,false);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutput instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withImageLabels(instance.getImageLabels()); 
    this.withPushSecret(instance.getPushSecret()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildOutput build() {
    BuildOutput buildable = new BuildOutput(fluent.getImageLabels(),fluent.getPushSecret(),fluent.getTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}