package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildListBuilder extends BuildListFluentImpl<BuildListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.BuildList,BuildListBuilder>{
  public BuildListBuilder() {
    this(false);
  }
  public BuildListBuilder(Boolean validationEnabled) {
    this(new BuildList(), validationEnabled);
  }
  public BuildListBuilder(io.fabric8.openshift.api.model.BuildListFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildListBuilder(io.fabric8.openshift.api.model.BuildListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildList(), validationEnabled);
  }
  public BuildListBuilder(io.fabric8.openshift.api.model.BuildListFluent<?> fluent,io.fabric8.openshift.api.model.BuildList instance) {
    this(fluent, instance, false);
  }
  public BuildListBuilder(io.fabric8.openshift.api.model.BuildListFluent<?> fluent,io.fabric8.openshift.api.model.BuildList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildListBuilder(io.fabric8.openshift.api.model.BuildList instance) {
    this(instance,false);
  }
  public BuildListBuilder(io.fabric8.openshift.api.model.BuildList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildList build() {
    BuildList buildable = new BuildList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}