package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildConfigStatusBuilder extends BuildConfigStatusFluentImpl<BuildConfigStatusBuilder> implements VisitableBuilder<BuildConfigStatus,io.fabric8.openshift.api.model.BuildConfigStatusBuilder>{
  public BuildConfigStatusBuilder() {
    this(false);
  }
  public BuildConfigStatusBuilder(Boolean validationEnabled) {
    this(new BuildConfigStatus(), validationEnabled);
  }
  public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildConfigStatus(), validationEnabled);
  }
  public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfigStatus instance) {
    this(fluent, instance, false);
  }
  public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfigStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImageChangeTriggers(instance.getImageChangeTriggers()); 
    fluent.withLastVersion(instance.getLastVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatus instance) {
    this(instance,false);
  }
  public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withImageChangeTriggers(instance.getImageChangeTriggers()); 
    this.withLastVersion(instance.getLastVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildConfigStatus build() {
    BuildConfigStatus buildable = new BuildConfigStatus(fluent.getImageChangeTriggers(),fluent.getLastVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}