package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildConfigSpecFluentImpl<A extends BuildConfigSpecFluent<A>> extends BaseFluent<A> implements BuildConfigSpecFluent<A>{
  public BuildConfigSpecFluentImpl() {
  }
  public BuildConfigSpecFluentImpl(io.fabric8.openshift.api.model.BuildConfigSpec instance) {
    this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
    this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit()); 
    this.withMountTrustedCA(instance.getMountTrustedCA()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withOutput(instance.getOutput()); 
    this.withPostCommit(instance.getPostCommit()); 
    this.withResources(instance.getResources()); 
    this.withRevision(instance.getRevision()); 
    this.withRunPolicy(instance.getRunPolicy()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withSource(instance.getSource()); 
    this.withStrategy(instance.getStrategy()); 
    this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit()); 
    this.withTriggers(instance.getTriggers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Long completionDeadlineSeconds;
  private Integer failedBuildsHistoryLimit;
  private Boolean mountTrustedCA;
  private Map<String,java.lang.String> nodeSelector;
  private BuildOutputBuilder output;
  private BuildPostCommitSpecBuilder postCommit;
  private ResourceRequirementsBuilder resources;
  private SourceRevisionBuilder revision;
  private java.lang.String runPolicy;
  private java.lang.String serviceAccount;
  private BuildSourceBuilder source;
  private BuildStrategyBuilder strategy;
  private java.lang.Integer successfulBuildsHistoryLimit;
  private ArrayList<BuildTriggerPolicyBuilder> triggers = new java.util.ArrayList<BuildTriggerPolicyBuilder>();
  private java.util.Map<java.lang.String,Object> additionalProperties;
  public java.lang.Long getCompletionDeadlineSeconds() {
    return this.completionDeadlineSeconds;
  }
  public A withCompletionDeadlineSeconds(java.lang.Long completionDeadlineSeconds) {
    this.completionDeadlineSeconds=completionDeadlineSeconds; return (A) this;
  }
  public java.lang.Boolean hasCompletionDeadlineSeconds() {
    return this.completionDeadlineSeconds != null;
  }
  public java.lang.Integer getFailedBuildsHistoryLimit() {
    return this.failedBuildsHistoryLimit;
  }
  public A withFailedBuildsHistoryLimit(java.lang.Integer failedBuildsHistoryLimit) {
    this.failedBuildsHistoryLimit=failedBuildsHistoryLimit; return (A) this;
  }
  public java.lang.Boolean hasFailedBuildsHistoryLimit() {
    return this.failedBuildsHistoryLimit != null;
  }
  public java.lang.Boolean getMountTrustedCA() {
    return this.mountTrustedCA;
  }
  public A withMountTrustedCA(java.lang.Boolean mountTrustedCA) {
    this.mountTrustedCA=mountTrustedCA; return (A) this;
  }
  public java.lang.Boolean hasMountTrustedCA() {
    return this.mountTrustedCA != null;
  }
  public A addToNodeSelector(java.lang.String key,java.lang.String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new java.util.LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(java.lang.String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(java.util.Map<java.lang.String,java.lang.String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new java.util.LinkedHashMap(nodeSelector);} return (A) this;
  }
  public java.lang.Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOutput instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.openshift.api.model.BuildOutput getOutput() {
    return this.output!=null ?this.output.build():null;
  }
  public io.fabric8.openshift.api.model.BuildOutput buildOutput() {
    return this.output!=null ?this.output.build():null;
  }
  public A withOutput(io.fabric8.openshift.api.model.BuildOutput output) {
    _visitables.get("output").remove(this.output);
    if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.get("output").add(this.output);} return (A) this;
  }
  public java.lang.Boolean hasOutput() {
    return this.output != null;
  }
  public BuildConfigSpecFluent.OutputNested<A> withNewOutput() {
    return new BuildConfigSpecFluentImpl.OutputNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> withNewOutputLike(io.fabric8.openshift.api.model.BuildOutput item) {
    return new BuildConfigSpecFluentImpl.OutputNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> editOutput() {
    return withNewOutputLike(getOutput());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> editOrNewOutput() {
    return withNewOutputLike(getOutput() != null ? getOutput(): new io.fabric8.openshift.api.model.BuildOutputBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> editOrNewOutputLike(io.fabric8.openshift.api.model.BuildOutput item) {
    return withNewOutputLike(getOutput() != null ? getOutput(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPostCommit instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public BuildPostCommitSpec getPostCommit() {
    return this.postCommit!=null ?this.postCommit.build():null;
  }
  public io.fabric8.openshift.api.model.BuildPostCommitSpec buildPostCommit() {
    return this.postCommit!=null ?this.postCommit.build():null;
  }
  public A withPostCommit(io.fabric8.openshift.api.model.BuildPostCommitSpec postCommit) {
    _visitables.get("postCommit").remove(this.postCommit);
    if (postCommit!=null){ this.postCommit= new io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder(postCommit); _visitables.get("postCommit").add(this.postCommit);} return (A) this;
  }
  public java.lang.Boolean hasPostCommit() {
    return this.postCommit != null;
  }
  public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommit() {
    return new BuildConfigSpecFluentImpl.PostCommitNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommitLike(io.fabric8.openshift.api.model.BuildPostCommitSpec item) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl.PostCommitNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> editPostCommit() {
    return withNewPostCommitLike(getPostCommit());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommit() {
    return withNewPostCommitLike(getPostCommit() != null ? getPostCommit(): new io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(io.fabric8.openshift.api.model.BuildPostCommitSpec item) {
    return withNewPostCommitLike(getPostCommit() != null ? getPostCommit(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public io.fabric8.kubernetes.api.model.ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return this.resources != null;
  }
  public BuildConfigSpecFluent.ResourcesNested<A> withNewResources() {
    return new BuildConfigSpecFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRevision instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public SourceRevision getRevision() {
    return this.revision!=null ?this.revision.build():null;
  }
  public io.fabric8.openshift.api.model.SourceRevision buildRevision() {
    return this.revision!=null ?this.revision.build():null;
  }
  public A withRevision(io.fabric8.openshift.api.model.SourceRevision revision) {
    _visitables.get("revision").remove(this.revision);
    if (revision!=null){ this.revision= new io.fabric8.openshift.api.model.SourceRevisionBuilder(revision); _visitables.get("revision").add(this.revision);} return (A) this;
  }
  public java.lang.Boolean hasRevision() {
    return this.revision != null;
  }
  public BuildConfigSpecFluent.RevisionNested<A> withNewRevision() {
    return new BuildConfigSpecFluentImpl.RevisionNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> withNewRevisionLike(io.fabric8.openshift.api.model.SourceRevision item) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl.RevisionNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> editRevision() {
    return withNewRevisionLike(getRevision());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> editOrNewRevision() {
    return withNewRevisionLike(getRevision() != null ? getRevision(): new io.fabric8.openshift.api.model.SourceRevisionBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> editOrNewRevisionLike(io.fabric8.openshift.api.model.SourceRevision item) {
    return withNewRevisionLike(getRevision() != null ? getRevision(): item);
  }
  public java.lang.String getRunPolicy() {
    return this.runPolicy;
  }
  public A withRunPolicy(java.lang.String runPolicy) {
    this.runPolicy=runPolicy; return (A) this;
  }
  public java.lang.Boolean hasRunPolicy() {
    return this.runPolicy != null;
  }
  public java.lang.String getServiceAccount() {
    return this.serviceAccount;
  }
  public A withServiceAccount(java.lang.String serviceAccount) {
    this.serviceAccount=serviceAccount; return (A) this;
  }
  public java.lang.Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSource instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public BuildSource getSource() {
    return this.source!=null ?this.source.build():null;
  }
  public io.fabric8.openshift.api.model.BuildSource buildSource() {
    return this.source!=null ?this.source.build():null;
  }
  public A withSource(io.fabric8.openshift.api.model.BuildSource source) {
    _visitables.get("source").remove(this.source);
    if (source!=null){ this.source= new io.fabric8.openshift.api.model.BuildSourceBuilder(source); _visitables.get("source").add(this.source);} return (A) this;
  }
  public java.lang.Boolean hasSource() {
    return this.source != null;
  }
  public BuildConfigSpecFluent.SourceNested<A> withNewSource() {
    return new BuildConfigSpecFluentImpl.SourceNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> withNewSourceLike(io.fabric8.openshift.api.model.BuildSource item) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl.SourceNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> editSource() {
    return withNewSourceLike(getSource());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> editOrNewSource() {
    return withNewSourceLike(getSource() != null ? getSource(): new io.fabric8.openshift.api.model.BuildSourceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> editOrNewSourceLike(io.fabric8.openshift.api.model.BuildSource item) {
    return withNewSourceLike(getSource() != null ? getSource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStrategy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.BuildStrategy getStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public io.fabric8.openshift.api.model.BuildStrategy buildStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public A withStrategy(io.fabric8.openshift.api.model.BuildStrategy strategy) {
    _visitables.get("strategy").remove(this.strategy);
    if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} return (A) this;
  }
  public java.lang.Boolean hasStrategy() {
    return this.strategy != null;
  }
  public BuildConfigSpecFluent.StrategyNested<A> withNewStrategy() {
    return new BuildConfigSpecFluentImpl.StrategyNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> withNewStrategyLike(io.fabric8.openshift.api.model.BuildStrategy item) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl.StrategyNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> editStrategy() {
    return withNewStrategyLike(getStrategy());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategy() {
    return withNewStrategyLike(getStrategy() != null ? getStrategy(): new io.fabric8.openshift.api.model.BuildStrategyBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(io.fabric8.openshift.api.model.BuildStrategy item) {
    return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
  }
  public java.lang.Integer getSuccessfulBuildsHistoryLimit() {
    return this.successfulBuildsHistoryLimit;
  }
  public A withSuccessfulBuildsHistoryLimit(java.lang.Integer successfulBuildsHistoryLimit) {
    this.successfulBuildsHistoryLimit=successfulBuildsHistoryLimit; return (A) this;
  }
  public java.lang.Boolean hasSuccessfulBuildsHistoryLimit() {
    return this.successfulBuildsHistoryLimit != null;
  }
  public A addToTriggers(java.lang.Integer index,io.fabric8.openshift.api.model.BuildTriggerPolicy item) {
    if (this.triggers == null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder>();}
    io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder(item);_visitables.get("triggers").add(index >= 0 ? index : _visitables.get("triggers").size(), builder);this.triggers.add(index >= 0 ? index : triggers.size(), builder); return (A)this;
  }
  public A setToTriggers(java.lang.Integer index,io.fabric8.openshift.api.model.BuildTriggerPolicy item) {
    if (this.triggers == null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder>();}
    io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder(item);
    if (index < 0 || index >= _visitables.get("triggers").size()) { _visitables.get("triggers").add(builder); } else { _visitables.get("triggers").set(index, builder);}
    if (index < 0 || index >= triggers.size()) { triggers.add(builder); } else { triggers.set(index, builder);}
     return (A)this;
  }
  public A addToTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... items) {
    if (this.triggers == null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder>();}
    for (io.fabric8.openshift.api.model.BuildTriggerPolicy item : items) {io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A addAllToTriggers(Collection<io.fabric8.openshift.api.model.BuildTriggerPolicy> items) {
    if (this.triggers == null) {this.triggers = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder>();}
    for (io.fabric8.openshift.api.model.BuildTriggerPolicy item : items) {io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A removeFromTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... items) {
    for (io.fabric8.openshift.api.model.BuildTriggerPolicy item : items) {io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggers(java.util.Collection<io.fabric8.openshift.api.model.BuildTriggerPolicy> items) {
    for (io.fabric8.openshift.api.model.BuildTriggerPolicy item : items) {io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggers(Predicate<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder> predicate) {
    if (triggers == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder> each = triggers.iterator();
    final List visitables = _visitables.get("triggers");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.openshift.api.model.BuildTriggerPolicy> getTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.BuildTriggerPolicy> buildTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public io.fabric8.openshift.api.model.BuildTriggerPolicy buildTrigger(java.lang.Integer index) {
    return this.triggers.get(index).build();
  }
  public io.fabric8.openshift.api.model.BuildTriggerPolicy buildFirstTrigger() {
    return this.triggers.get(0).build();
  }
  public io.fabric8.openshift.api.model.BuildTriggerPolicy buildLastTrigger() {
    return this.triggers.get(triggers.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.BuildTriggerPolicy buildMatchingTrigger(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingTrigger(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggers(java.util.List<io.fabric8.openshift.api.model.BuildTriggerPolicy> triggers) {
    if (this.triggers != null) { _visitables.get("triggers").removeAll(this.triggers);}
    if (triggers != null) {this.triggers = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.BuildTriggerPolicy item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
  }
  public A withTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... triggers) {
    if (this.triggers != null) {this.triggers.clear();}
    if (triggers != null) {for (io.fabric8.openshift.api.model.BuildTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (A) this;
  }
  public java.lang.Boolean hasTriggers() {
    return triggers != null && !triggers.isEmpty();
  }
  public BuildConfigSpecFluent.TriggersNested<A> addNewTrigger() {
    return new BuildConfigSpecFluentImpl.TriggersNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> addNewTriggerLike(io.fabric8.openshift.api.model.BuildTriggerPolicy item) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl.TriggersNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> setNewTriggerLike(java.lang.Integer index,io.fabric8.openshift.api.model.BuildTriggerPolicy item) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl.TriggersNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> editTrigger(java.lang.Integer index) {
    if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> editFirstTrigger() {
    if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
    return setNewTriggerLike(0, buildTrigger(0));
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> editLastTrigger() {
    int index = triggers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> editMatchingTrigger(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggers.size();i++) { 
    if (predicate.test(triggers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuildConfigSpecFluentImpl that = (BuildConfigSpecFluentImpl) o;
    if (completionDeadlineSeconds != null ? !completionDeadlineSeconds.equals(that.completionDeadlineSeconds) :that.completionDeadlineSeconds != null) return false;
    if (failedBuildsHistoryLimit != null ? !failedBuildsHistoryLimit.equals(that.failedBuildsHistoryLimit) :that.failedBuildsHistoryLimit != null) return false;
    if (mountTrustedCA != null ? !mountTrustedCA.equals(that.mountTrustedCA) :that.mountTrustedCA != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (output != null ? !output.equals(that.output) :that.output != null) return false;
    if (postCommit != null ? !postCommit.equals(that.postCommit) :that.postCommit != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
    if (runPolicy != null ? !runPolicy.equals(that.runPolicy) :that.runPolicy != null) return false;
    if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
    if (source != null ? !source.equals(that.source) :that.source != null) return false;
    if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
    if (successfulBuildsHistoryLimit != null ? !successfulBuildsHistoryLimit.equals(that.successfulBuildsHistoryLimit) :that.successfulBuildsHistoryLimit != null) return false;
    if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(completionDeadlineSeconds,  failedBuildsHistoryLimit,  mountTrustedCA,  nodeSelector,  output,  postCommit,  resources,  revision,  runPolicy,  serviceAccount,  source,  strategy,  successfulBuildsHistoryLimit,  triggers,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (completionDeadlineSeconds != null) { sb.append("completionDeadlineSeconds:"); sb.append(completionDeadlineSeconds + ","); }
    if (failedBuildsHistoryLimit != null) { sb.append("failedBuildsHistoryLimit:"); sb.append(failedBuildsHistoryLimit + ","); }
    if (mountTrustedCA != null) { sb.append("mountTrustedCA:"); sb.append(mountTrustedCA + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (output != null) { sb.append("output:"); sb.append(output + ","); }
    if (postCommit != null) { sb.append("postCommit:"); sb.append(postCommit + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (runPolicy != null) { sb.append("runPolicy:"); sb.append(runPolicy + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (successfulBuildsHistoryLimit != null) { sb.append("successfulBuildsHistoryLimit:"); sb.append(successfulBuildsHistoryLimit + ","); }
    if (triggers != null && !triggers.isEmpty()) { sb.append("triggers:"); sb.append(triggers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withMountTrustedCA() {
    return withMountTrustedCA(true);
  }
  class OutputNestedImpl<N> extends BuildOutputFluentImpl<BuildConfigSpecFluent.OutputNested<N>> implements io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<N>,Nested<N>{
    OutputNestedImpl(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    OutputNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildOutputBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildOutputBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withOutput(builder.build());
    }
    public N endOutput() {
      return and();
    }
    
  }
  class PostCommitNestedImpl<N> extends BuildPostCommitSpecFluentImpl<BuildConfigSpecFluent.PostCommitNested<N>> implements io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PostCommitNestedImpl(io.fabric8.openshift.api.model.BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    PostCommitNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withPostCommit(builder.build());
    }
    public N endPostCommit() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<BuildConfigSpecFluent.ResourcesNested<N>> implements io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourcesNestedImpl(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<BuildConfigSpecFluent.RevisionNested<N>> implements io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RevisionNestedImpl(io.fabric8.openshift.api.model.SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    RevisionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SourceRevisionBuilder(this);
    }
    io.fabric8.openshift.api.model.SourceRevisionBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withRevision(builder.build());
    }
    public N endRevision() {
      return and();
    }
    
  }
  class SourceNestedImpl<N> extends BuildSourceFluentImpl<BuildConfigSpecFluent.SourceNested<N>> implements io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SourceNestedImpl(io.fabric8.openshift.api.model.BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    SourceNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildSourceBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildSourceBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withSource(builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  class StrategyNestedImpl<N> extends BuildStrategyFluentImpl<BuildConfigSpecFluent.StrategyNested<N>> implements io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StrategyNestedImpl(io.fabric8.openshift.api.model.BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    StrategyNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildStrategyBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildStrategyBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy() {
      return and();
    }
    
  }
  class TriggersNestedImpl<N> extends BuildTriggerPolicyFluentImpl<BuildConfigSpecFluent.TriggersNested<N>> implements io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TriggersNestedImpl(java.lang.Integer index,BuildTriggerPolicy item) {
      this.index = index;
      this.builder = new BuildTriggerPolicyBuilder(this, item);
    }
    TriggersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.setToTriggers(index,builder.build());
    }
    public N endTrigger() {
      return and();
    }
    
  }
  
}