package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildConfigListBuilder extends BuildConfigListFluentImpl<BuildConfigListBuilder> implements VisitableBuilder<BuildConfigList,io.fabric8.openshift.api.model.BuildConfigListBuilder>{
  public BuildConfigListBuilder() {
    this(false);
  }
  public BuildConfigListBuilder(Boolean validationEnabled) {
    this(new BuildConfigList(), validationEnabled);
  }
  public BuildConfigListBuilder(BuildConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildConfigListBuilder(io.fabric8.openshift.api.model.BuildConfigListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildConfigList(), validationEnabled);
  }
  public BuildConfigListBuilder(io.fabric8.openshift.api.model.BuildConfigListFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfigList instance) {
    this(fluent, instance, false);
  }
  public BuildConfigListBuilder(io.fabric8.openshift.api.model.BuildConfigListFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfigList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildConfigListBuilder(io.fabric8.openshift.api.model.BuildConfigList instance) {
    this(instance,false);
  }
  public BuildConfigListBuilder(io.fabric8.openshift.api.model.BuildConfigList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildConfigListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildConfigList build() {
    BuildConfigList buildable = new BuildConfigList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}