package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerTemplateInstanceListBuilder extends BrokerTemplateInstanceListFluentImpl<BrokerTemplateInstanceListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.BrokerTemplateInstanceList,io.fabric8.openshift.api.model.BrokerTemplateInstanceListBuilder>{
  public BrokerTemplateInstanceListBuilder() {
    this(false);
  }
  public BrokerTemplateInstanceListBuilder(Boolean validationEnabled) {
    this(new BrokerTemplateInstanceList(), validationEnabled);
  }
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceListFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerTemplateInstanceListBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BrokerTemplateInstanceList(), validationEnabled);
  }
  public BrokerTemplateInstanceListBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceListFluent<?> fluent,io.fabric8.openshift.api.model.BrokerTemplateInstanceList instance) {
    this(fluent, instance, false);
  }
  public BrokerTemplateInstanceListBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceListFluent<?> fluent,io.fabric8.openshift.api.model.BrokerTemplateInstanceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BrokerTemplateInstanceListBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceList instance) {
    this(instance,false);
  }
  public BrokerTemplateInstanceListBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BrokerTemplateInstanceListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceList build() {
    BrokerTemplateInstanceList buildable = new BrokerTemplateInstanceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}