package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerTemplateInstanceBuilder extends BrokerTemplateInstanceFluentImpl<BrokerTemplateInstanceBuilder> implements VisitableBuilder<BrokerTemplateInstance,io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder>{
  public BrokerTemplateInstanceBuilder() {
    this(false);
  }
  public BrokerTemplateInstanceBuilder(Boolean validationEnabled) {
    this(new BrokerTemplateInstance(), validationEnabled);
  }
  public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BrokerTemplateInstance(), validationEnabled);
  }
  public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent,io.fabric8.openshift.api.model.BrokerTemplateInstance instance) {
    this(fluent, instance, false);
  }
  public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent,io.fabric8.openshift.api.model.BrokerTemplateInstance instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstance instance) {
    this(instance,false);
  }
  public BrokerTemplateInstanceBuilder(io.fabric8.openshift.api.model.BrokerTemplateInstance instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BrokerTemplateInstance build() {
    BrokerTemplateInstance buildable = new BrokerTemplateInstance(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}