package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzurePlatformStatusBuilder extends AzurePlatformStatusFluentImpl<AzurePlatformStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.AzurePlatformStatus,io.fabric8.openshift.api.model.AzurePlatformStatusBuilder>{
  public AzurePlatformStatusBuilder() {
    this(false);
  }
  public AzurePlatformStatusBuilder(Boolean validationEnabled) {
    this(new AzurePlatformStatus(), validationEnabled);
  }
  public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AzurePlatformStatus(), validationEnabled);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.AzurePlatformStatus instance) {
    this(fluent, instance, false);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.AzurePlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArmEndpoint(instance.getArmEndpoint()); 
    fluent.withCloudName(instance.getCloudName()); 
    fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    fluent.withResourceGroupName(instance.getResourceGroupName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatus instance) {
    this(instance,false);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withArmEndpoint(instance.getArmEndpoint()); 
    this.withCloudName(instance.getCloudName()); 
    this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AzurePlatformStatus build() {
    AzurePlatformStatus buildable = new AzurePlatformStatus(fluent.getArmEndpoint(),fluent.getCloudName(),fluent.getNetworkResourceGroupName(),fluent.getResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}