package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationSpecBuilder extends AuthenticationSpecFluentImpl<AuthenticationSpecBuilder> implements VisitableBuilder<AuthenticationSpec,io.fabric8.openshift.api.model.AuthenticationSpecBuilder>{
  public AuthenticationSpecBuilder() {
    this(false);
  }
  public AuthenticationSpecBuilder(Boolean validationEnabled) {
    this(new AuthenticationSpec(), validationEnabled);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AuthenticationSpec(), validationEnabled);
  }
  public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent,io.fabric8.openshift.api.model.AuthenticationSpec instance) {
    this(fluent, instance, false);
  }
  public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent,io.fabric8.openshift.api.model.AuthenticationSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withOauthMetadata(instance.getOauthMetadata()); 
    fluent.withServiceAccountIssuer(instance.getServiceAccountIssuer()); 
    fluent.withType(instance.getType()); 
    fluent.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator()); 
    fluent.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpec instance) {
    this(instance,false);
  }
  public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withOauthMetadata(instance.getOauthMetadata()); 
    this.withServiceAccountIssuer(instance.getServiceAccountIssuer()); 
    this.withType(instance.getType()); 
    this.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator()); 
    this.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AuthenticationSpec build() {
    AuthenticationSpec buildable = new AuthenticationSpec(fluent.getOauthMetadata(),fluent.getServiceAccountIssuer(),fluent.getType(),fluent.getWebhookTokenAuthenticator(),fluent.getWebhookTokenAuthenticators());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}