package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationListBuilder extends AuthenticationListFluentImpl<AuthenticationListBuilder> implements VisitableBuilder<AuthenticationList,io.fabric8.openshift.api.model.AuthenticationListBuilder>{
  public AuthenticationListBuilder() {
    this(false);
  }
  public AuthenticationListBuilder(Boolean validationEnabled) {
    this(new AuthenticationList(), validationEnabled);
  }
  public AuthenticationListBuilder(AuthenticationListFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationListBuilder(io.fabric8.openshift.api.model.AuthenticationListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AuthenticationList(), validationEnabled);
  }
  public AuthenticationListBuilder(io.fabric8.openshift.api.model.AuthenticationListFluent<?> fluent,io.fabric8.openshift.api.model.AuthenticationList instance) {
    this(fluent, instance, false);
  }
  public AuthenticationListBuilder(io.fabric8.openshift.api.model.AuthenticationListFluent<?> fluent,io.fabric8.openshift.api.model.AuthenticationList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationListBuilder(io.fabric8.openshift.api.model.AuthenticationList instance) {
    this(instance,false);
  }
  public AuthenticationListBuilder(io.fabric8.openshift.api.model.AuthenticationList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AuthenticationListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AuthenticationList build() {
    AuthenticationList buildable = new AuthenticationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}