package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuditBuilder extends AuditFluentImpl<AuditBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.Audit,AuditBuilder>{
  public AuditBuilder() {
    this(false);
  }
  public AuditBuilder(Boolean validationEnabled) {
    this(new Audit(), validationEnabled);
  }
  public AuditBuilder(io.fabric8.openshift.api.model.AuditFluent<?> fluent) {
    this(fluent, false);
  }
  public AuditBuilder(io.fabric8.openshift.api.model.AuditFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Audit(), validationEnabled);
  }
  public AuditBuilder(io.fabric8.openshift.api.model.AuditFluent<?> fluent,io.fabric8.openshift.api.model.Audit instance) {
    this(fluent, instance, false);
  }
  public AuditBuilder(io.fabric8.openshift.api.model.AuditFluent<?> fluent,io.fabric8.openshift.api.model.Audit instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCustomRules(instance.getCustomRules()); 
    fluent.withProfile(instance.getProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuditBuilder(io.fabric8.openshift.api.model.Audit instance) {
    this(instance,false);
  }
  public AuditBuilder(io.fabric8.openshift.api.model.Audit instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCustomRules(instance.getCustomRules()); 
    this.withProfile(instance.getProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AuditFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Audit build() {
    Audit buildable = new Audit(fluent.getCustomRules(),fluent.getProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}