package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSPlatformSpecBuilder extends AWSPlatformSpecFluentImpl<AWSPlatformSpecBuilder> implements VisitableBuilder<AWSPlatformSpec,io.fabric8.openshift.api.model.AWSPlatformSpecBuilder>{
  public AWSPlatformSpecBuilder() {
    this(false);
  }
  public AWSPlatformSpecBuilder(Boolean validationEnabled) {
    this(new AWSPlatformSpec(), validationEnabled);
  }
  public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSPlatformSpec(), validationEnabled);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent,io.fabric8.openshift.api.model.AWSPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent,io.fabric8.openshift.api.model.AWSPlatformSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpec instance) {
    this(instance,false);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AWSPlatformSpec build() {
    AWSPlatformSpec buildable = new AWSPlatformSpec(fluent.getServiceEndpoints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}