package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerNamedServingCertBuilder extends APIServerNamedServingCertFluentImpl<APIServerNamedServingCertBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.APIServerNamedServingCert,APIServerNamedServingCertBuilder>{
  public APIServerNamedServingCertBuilder() {
    this(false);
  }
  public APIServerNamedServingCertBuilder(Boolean validationEnabled) {
    this(new APIServerNamedServingCert(), validationEnabled);
  }
  public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerNamedServingCertBuilder(io.fabric8.openshift.api.model.APIServerNamedServingCertFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServerNamedServingCert(), validationEnabled);
  }
  public APIServerNamedServingCertBuilder(io.fabric8.openshift.api.model.APIServerNamedServingCertFluent<?> fluent,io.fabric8.openshift.api.model.APIServerNamedServingCert instance) {
    this(fluent, instance, false);
  }
  public APIServerNamedServingCertBuilder(io.fabric8.openshift.api.model.APIServerNamedServingCertFluent<?> fluent,io.fabric8.openshift.api.model.APIServerNamedServingCert instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNames(instance.getNames()); 
    fluent.withServingCertificate(instance.getServingCertificate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServerNamedServingCertBuilder(io.fabric8.openshift.api.model.APIServerNamedServingCert instance) {
    this(instance,false);
  }
  public APIServerNamedServingCertBuilder(io.fabric8.openshift.api.model.APIServerNamedServingCert instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNames(instance.getNames()); 
    this.withServingCertificate(instance.getServingCertificate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.APIServerNamedServingCertFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.APIServerNamedServingCert build() {
    APIServerNamedServingCert buildable = new APIServerNamedServingCert(fluent.getNames(),fluent.getServingCertificate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}