package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerBuilder extends APIServerFluentImpl<APIServerBuilder> implements VisitableBuilder<APIServer,io.fabric8.openshift.api.model.APIServerBuilder>{
  public APIServerBuilder() {
    this(false);
  }
  public APIServerBuilder(Boolean validationEnabled) {
    this(new APIServer(), validationEnabled);
  }
  public APIServerBuilder(APIServerFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServer(), validationEnabled);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServerFluent<?> fluent,io.fabric8.openshift.api.model.APIServer instance) {
    this(fluent, instance, false);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServerFluent<?> fluent,io.fabric8.openshift.api.model.APIServer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServer instance) {
    this(instance,false);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.APIServerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.APIServer build() {
    APIServer buildable = new APIServer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}