package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SourceRevisionFluentImpl<A extends SourceRevisionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SourceRevisionFluent<A> {

    private GitSourceRevisionBuilder git;
    private String type;

    public SourceRevisionFluentImpl() {
    }

    public SourceRevisionFluentImpl(SourceRevision instance) {
        this.withGit(instance.getGit()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildGit instead.
 * @return The buildable object.
 */
@Deprecated public GitSourceRevision getGit() {
        return this.git!=null?this.git.build():null;
    }

    public GitSourceRevision buildGit() {
        return this.git!=null?this.git.build():null;
    }

    public A withGit(GitSourceRevision git) {
        _visitables.get("git").remove(this.git);
        if (git!=null){ this.git= new GitSourceRevisionBuilder(git); _visitables.get("git").add(this.git);} return (A) this;
    }

    public Boolean hasGit() {
        return this.git != null;
    }

    public io.fabric8.openshift.api.model.SourceRevisionFluent.GitNested<A> withNewGit() {
        return new GitNestedImpl();
    }

    public io.fabric8.openshift.api.model.SourceRevisionFluent.GitNested<A> withNewGitLike(GitSourceRevision item) {
        return new GitNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SourceRevisionFluent.GitNested<A> editGit() {
        return withNewGitLike(getGit());
    }

    public io.fabric8.openshift.api.model.SourceRevisionFluent.GitNested<A> editOrNewGit() {
        return withNewGitLike(getGit() != null ? getGit(): new GitSourceRevisionBuilder().build());
    }

    public io.fabric8.openshift.api.model.SourceRevisionFluent.GitNested<A> editOrNewGitLike(GitSourceRevision item) {
        return withNewGitLike(getGit() != null ? getGit(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SourceRevisionFluentImpl that = (SourceRevisionFluentImpl) o;
        if (git != null ? !git.equals(that.git) :that.git != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(git,  type,  super.hashCode());
    }

    public class GitNestedImpl<N> extends GitSourceRevisionFluentImpl<io.fabric8.openshift.api.model.SourceRevisionFluent.GitNested<N>> implements io.fabric8.openshift.api.model.SourceRevisionFluent.GitNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitSourceRevisionBuilder builder;

            GitNestedImpl(GitSourceRevision item) {
                this.builder = new GitSourceRevisionBuilder(this, item);
                        
            }

            GitNestedImpl() {
                this.builder = new GitSourceRevisionBuilder(this);
                        
            }

            public N and() {
                return (N) SourceRevisionFluentImpl.this.withGit(builder.build());
            }

            public N endGit() {
                return and();
            }
    }


}
