package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SignatureSubjectFluentImpl<A extends SignatureSubjectFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SignatureSubjectFluent<A> {

    private String commonName;
    private String organization;
    private String publicKeyID;

    public SignatureSubjectFluentImpl() {
    }

    public SignatureSubjectFluentImpl(SignatureSubject instance) {
        this.withCommonName(instance.getCommonName()); 
        this.withOrganization(instance.getOrganization()); 
        this.withPublicKeyID(instance.getPublicKeyID()); 
    }

    public String getCommonName() {
        return this.commonName;
    }

    public A withCommonName(String commonName) {
        this.commonName=commonName; return (A) this;
    }

    public Boolean hasCommonName() {
        return this.commonName != null;
    }

    public A withNewCommonName(StringBuilder arg1) {
        return (A)withCommonName(new String(arg1));
    }

    public A withNewCommonName(int[] arg1,int arg2,int arg3) {
        return (A)withCommonName(new String(arg1, arg2, arg3));
    }

    public A withNewCommonName(char[] arg1) {
        return (A)withCommonName(new String(arg1));
    }

    public A withNewCommonName(StringBuffer arg1) {
        return (A)withCommonName(new String(arg1));
    }

    public A withNewCommonName(byte[] arg1,int arg2) {
        return (A)withCommonName(new String(arg1, arg2));
    }

    public A withNewCommonName(byte[] arg1) {
        return (A)withCommonName(new String(arg1));
    }

    public A withNewCommonName(char[] arg1,int arg2,int arg3) {
        return (A)withCommonName(new String(arg1, arg2, arg3));
    }

    public A withNewCommonName(byte[] arg1,int arg2,int arg3) {
        return (A)withCommonName(new String(arg1, arg2, arg3));
    }

    public A withNewCommonName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCommonName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCommonName(String arg1) {
        return (A)withCommonName(new String(arg1));
    }

    public String getOrganization() {
        return this.organization;
    }

    public A withOrganization(String organization) {
        this.organization=organization; return (A) this;
    }

    public Boolean hasOrganization() {
        return this.organization != null;
    }

    public A withNewOrganization(StringBuilder arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public A withNewOrganization(int[] arg1,int arg2,int arg3) {
        return (A)withOrganization(new String(arg1, arg2, arg3));
    }

    public A withNewOrganization(char[] arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public A withNewOrganization(StringBuffer arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public A withNewOrganization(byte[] arg1,int arg2) {
        return (A)withOrganization(new String(arg1, arg2));
    }

    public A withNewOrganization(byte[] arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public A withNewOrganization(char[] arg1,int arg2,int arg3) {
        return (A)withOrganization(new String(arg1, arg2, arg3));
    }

    public A withNewOrganization(byte[] arg1,int arg2,int arg3) {
        return (A)withOrganization(new String(arg1, arg2, arg3));
    }

    public A withNewOrganization(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withOrganization(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewOrganization(String arg1) {
        return (A)withOrganization(new String(arg1));
    }

    public String getPublicKeyID() {
        return this.publicKeyID;
    }

    public A withPublicKeyID(String publicKeyID) {
        this.publicKeyID=publicKeyID; return (A) this;
    }

    public Boolean hasPublicKeyID() {
        return this.publicKeyID != null;
    }

    public A withNewPublicKeyID(StringBuilder arg1) {
        return (A)withPublicKeyID(new String(arg1));
    }

    public A withNewPublicKeyID(int[] arg1,int arg2,int arg3) {
        return (A)withPublicKeyID(new String(arg1, arg2, arg3));
    }

    public A withNewPublicKeyID(char[] arg1) {
        return (A)withPublicKeyID(new String(arg1));
    }

    public A withNewPublicKeyID(StringBuffer arg1) {
        return (A)withPublicKeyID(new String(arg1));
    }

    public A withNewPublicKeyID(byte[] arg1,int arg2) {
        return (A)withPublicKeyID(new String(arg1, arg2));
    }

    public A withNewPublicKeyID(byte[] arg1) {
        return (A)withPublicKeyID(new String(arg1));
    }

    public A withNewPublicKeyID(char[] arg1,int arg2,int arg3) {
        return (A)withPublicKeyID(new String(arg1, arg2, arg3));
    }

    public A withNewPublicKeyID(byte[] arg1,int arg2,int arg3) {
        return (A)withPublicKeyID(new String(arg1, arg2, arg3));
    }

    public A withNewPublicKeyID(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPublicKeyID(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPublicKeyID(String arg1) {
        return (A)withPublicKeyID(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SignatureSubjectFluentImpl that = (SignatureSubjectFluentImpl) o;
        if (commonName != null ? !commonName.equals(that.commonName) :that.commonName != null) return false;
        if (organization != null ? !organization.equals(that.organization) :that.organization != null) return false;
        if (publicKeyID != null ? !publicKeyID.equals(that.publicKeyID) :that.publicKeyID != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(commonName,  organization,  publicKeyID,  super.hashCode());
    }

}
