package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SelfSubjectRulesReviewSpecBuilder extends SelfSubjectRulesReviewSpecFluentImpl<SelfSubjectRulesReviewSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<SelfSubjectRulesReviewSpec,SelfSubjectRulesReviewSpecBuilder> {

    SelfSubjectRulesReviewSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SelfSubjectRulesReviewSpecBuilder() {
        this(true);
    }

    public SelfSubjectRulesReviewSpecBuilder(Boolean validationEnabled) {
        this(new SelfSubjectRulesReviewSpec(), validationEnabled);
    }

    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SelfSubjectRulesReviewSpec(), validationEnabled);
    }

    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance) {
        this(fluent, instance, true);
    }

    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withScopes(instance.getScopes()); 
        this.validationEnabled = validationEnabled; 
    }

    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance) {
        this(instance,true);
    }

    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withScopes(instance.getScopes()); 
        this.validationEnabled = validationEnabled; 
    }

    public SelfSubjectRulesReviewSpec build() {
        SelfSubjectRulesReviewSpec buildable = new SelfSubjectRulesReviewSpec(fluent.getScopes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SelfSubjectRulesReviewSpecBuilder that = (SelfSubjectRulesReviewSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
