package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface SecurityContextConstraintsFluent<A extends SecurityContextConstraintsFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Boolean getAllowHostDirVolumePlugin();
    public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin);
    public Boolean hasAllowHostDirVolumePlugin();
    public A withNewAllowHostDirVolumePlugin(String arg1);
    public A withNewAllowHostDirVolumePlugin(boolean arg1);
    public Boolean getAllowHostIPC();
    public A withAllowHostIPC(Boolean allowHostIPC);
    public Boolean hasAllowHostIPC();
    public A withNewAllowHostIPC(String arg1);
    public A withNewAllowHostIPC(boolean arg1);
    public Boolean getAllowHostNetwork();
    public A withAllowHostNetwork(Boolean allowHostNetwork);
    public Boolean hasAllowHostNetwork();
    public A withNewAllowHostNetwork(String arg1);
    public A withNewAllowHostNetwork(boolean arg1);
    public Boolean getAllowHostPID();
    public A withAllowHostPID(Boolean allowHostPID);
    public Boolean hasAllowHostPID();
    public A withNewAllowHostPID(String arg1);
    public A withNewAllowHostPID(boolean arg1);
    public Boolean getAllowHostPorts();
    public A withAllowHostPorts(Boolean allowHostPorts);
    public Boolean hasAllowHostPorts();
    public A withNewAllowHostPorts(String arg1);
    public A withNewAllowHostPorts(boolean arg1);
    public Boolean getAllowPrivilegeEscalation();
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation);
    public Boolean hasAllowPrivilegeEscalation();
    public A withNewAllowPrivilegeEscalation(String arg1);
    public A withNewAllowPrivilegeEscalation(boolean arg1);
    public Boolean getAllowPrivilegedContainer();
    public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer);
    public Boolean hasAllowPrivilegedContainer();
    public A withNewAllowPrivilegedContainer(String arg1);
    public A withNewAllowPrivilegedContainer(boolean arg1);
    public A addToAllowedCapabilities(int index,String item);
    public A setToAllowedCapabilities(int index,String item);
    public A addToAllowedCapabilities(String... items);
    public A addAllToAllowedCapabilities(Collection<String> items);
    public A removeFromAllowedCapabilities(String... items);
    public A removeAllFromAllowedCapabilities(Collection<String> items);
    public List<String> getAllowedCapabilities();
    public String getAllowedCapability(int index);
    public String getFirstAllowedCapability();
    public String getLastAllowedCapability();
    public String getMatchingAllowedCapability(Predicate<String> predicate);
    public Boolean hasMatchingAllowedCapability(Predicate<String> predicate);
    public A withAllowedCapabilities(List<String> allowedCapabilities);
    public A withAllowedCapabilities(String... allowedCapabilities);
    public Boolean hasAllowedCapabilities();
    public A addNewAllowedCapability(StringBuilder arg1);
    public A addNewAllowedCapability(int[] arg1,int arg2,int arg3);
    public A addNewAllowedCapability(char[] arg1);
    public A addNewAllowedCapability(StringBuffer arg1);
    public A addNewAllowedCapability(byte[] arg1,int arg2);
    public A addNewAllowedCapability(byte[] arg1);
    public A addNewAllowedCapability(char[] arg1,int arg2,int arg3);
    public A addNewAllowedCapability(byte[] arg1,int arg2,int arg3);
    public A addNewAllowedCapability(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAllowedCapability(String arg1);
    public A addToAllowedFlexVolumes(int index,AllowedFlexVolume item);
    public A setToAllowedFlexVolumes(int index,AllowedFlexVolume item);
    public A addToAllowedFlexVolumes(AllowedFlexVolume... items);
    public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items);
    public A removeFromAllowedFlexVolumes(AllowedFlexVolume... items);
    public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items);
    public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<AllowedFlexVolume> getAllowedFlexVolumes();
    public List<AllowedFlexVolume> buildAllowedFlexVolumes();
    public AllowedFlexVolume buildAllowedFlexVolume(int index);
    public AllowedFlexVolume buildFirstAllowedFlexVolume();
    public AllowedFlexVolume buildLastAllowedFlexVolume();
    public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
    public Boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
    public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes);
    public A withAllowedFlexVolumes(AllowedFlexVolume... allowedFlexVolumes);
    public Boolean hasAllowedFlexVolumes();
    public A addNewAllowedFlexVolume(String driver);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index,AllowedFlexVolume item);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
    public A addToAllowedUnsafeSysctls(int index,String item);
    public A setToAllowedUnsafeSysctls(int index,String item);
    public A addToAllowedUnsafeSysctls(String... items);
    public A addAllToAllowedUnsafeSysctls(Collection<String> items);
    public A removeFromAllowedUnsafeSysctls(String... items);
    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items);
    public List<String> getAllowedUnsafeSysctls();
    public String getAllowedUnsafeSysctl(int index);
    public String getFirstAllowedUnsafeSysctl();
    public String getLastAllowedUnsafeSysctl();
    public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate);
    public Boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate);
    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls);
    public A withAllowedUnsafeSysctls(String... allowedUnsafeSysctls);
    public Boolean hasAllowedUnsafeSysctls();
    public A addNewAllowedUnsafeSysctl(StringBuilder arg1);
    public A addNewAllowedUnsafeSysctl(int[] arg1,int arg2,int arg3);
    public A addNewAllowedUnsafeSysctl(char[] arg1);
    public A addNewAllowedUnsafeSysctl(StringBuffer arg1);
    public A addNewAllowedUnsafeSysctl(byte[] arg1,int arg2);
    public A addNewAllowedUnsafeSysctl(byte[] arg1);
    public A addNewAllowedUnsafeSysctl(char[] arg1,int arg2,int arg3);
    public A addNewAllowedUnsafeSysctl(byte[] arg1,int arg2,int arg3);
    public A addNewAllowedUnsafeSysctl(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAllowedUnsafeSysctl(String arg1);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToDefaultAddCapabilities(int index,String item);
    public A setToDefaultAddCapabilities(int index,String item);
    public A addToDefaultAddCapabilities(String... items);
    public A addAllToDefaultAddCapabilities(Collection<String> items);
    public A removeFromDefaultAddCapabilities(String... items);
    public A removeAllFromDefaultAddCapabilities(Collection<String> items);
    public List<String> getDefaultAddCapabilities();
    public String getDefaultAddCapability(int index);
    public String getFirstDefaultAddCapability();
    public String getLastDefaultAddCapability();
    public String getMatchingDefaultAddCapability(Predicate<String> predicate);
    public Boolean hasMatchingDefaultAddCapability(Predicate<String> predicate);
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities);
    public A withDefaultAddCapabilities(String... defaultAddCapabilities);
    public Boolean hasDefaultAddCapabilities();
    public A addNewDefaultAddCapability(StringBuilder arg1);
    public A addNewDefaultAddCapability(int[] arg1,int arg2,int arg3);
    public A addNewDefaultAddCapability(char[] arg1);
    public A addNewDefaultAddCapability(StringBuffer arg1);
    public A addNewDefaultAddCapability(byte[] arg1,int arg2);
    public A addNewDefaultAddCapability(byte[] arg1);
    public A addNewDefaultAddCapability(char[] arg1,int arg2,int arg3);
    public A addNewDefaultAddCapability(byte[] arg1,int arg2,int arg3);
    public A addNewDefaultAddCapability(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewDefaultAddCapability(String arg1);
    public Boolean getDefaultAllowPrivilegeEscalation();
    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation);
    public Boolean hasDefaultAllowPrivilegeEscalation();
    public A withNewDefaultAllowPrivilegeEscalation(String arg1);
    public A withNewDefaultAllowPrivilegeEscalation(boolean arg1);
    public A addToForbiddenSysctls(int index,String item);
    public A setToForbiddenSysctls(int index,String item);
    public A addToForbiddenSysctls(String... items);
    public A addAllToForbiddenSysctls(Collection<String> items);
    public A removeFromForbiddenSysctls(String... items);
    public A removeAllFromForbiddenSysctls(Collection<String> items);
    public List<String> getForbiddenSysctls();
    public String getForbiddenSysctl(int index);
    public String getFirstForbiddenSysctl();
    public String getLastForbiddenSysctl();
    public String getMatchingForbiddenSysctl(Predicate<String> predicate);
    public Boolean hasMatchingForbiddenSysctl(Predicate<String> predicate);
    public A withForbiddenSysctls(List<String> forbiddenSysctls);
    public A withForbiddenSysctls(String... forbiddenSysctls);
    public Boolean hasForbiddenSysctls();
    public A addNewForbiddenSysctl(StringBuilder arg1);
    public A addNewForbiddenSysctl(int[] arg1,int arg2,int arg3);
    public A addNewForbiddenSysctl(char[] arg1);
    public A addNewForbiddenSysctl(StringBuffer arg1);
    public A addNewForbiddenSysctl(byte[] arg1,int arg2);
    public A addNewForbiddenSysctl(byte[] arg1);
    public A addNewForbiddenSysctl(char[] arg1,int arg2,int arg3);
    public A addNewForbiddenSysctl(byte[] arg1,int arg2,int arg3);
    public A addNewForbiddenSysctl(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewForbiddenSysctl(String arg1);
    
/**
 * This method has been deprecated, please use method buildFsGroup instead.
 * @return The buildable object.
 */
@Deprecated public FSGroupStrategyOptions getFsGroup();
    public FSGroupStrategyOptions buildFsGroup();
    public A withFsGroup(FSGroupStrategyOptions fsGroup);
    public Boolean hasFsGroup();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroup();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item);
    public A addToGroups(int index,String item);
    public A setToGroups(int index,String item);
    public A addToGroups(String... items);
    public A addAllToGroups(Collection<String> items);
    public A removeFromGroups(String... items);
    public A removeAllFromGroups(Collection<String> items);
    public List<String> getGroups();
    public String getGroup(int index);
    public String getFirstGroup();
    public String getLastGroup();
    public String getMatchingGroup(Predicate<String> predicate);
    public Boolean hasMatchingGroup(Predicate<String> predicate);
    public A withGroups(List<String> groups);
    public A withGroups(String... groups);
    public Boolean hasGroups();
    public A addNewGroup(StringBuilder arg1);
    public A addNewGroup(int[] arg1,int arg2,int arg3);
    public A addNewGroup(char[] arg1);
    public A addNewGroup(StringBuffer arg1);
    public A addNewGroup(byte[] arg1,int arg2);
    public A addNewGroup(byte[] arg1);
    public A addNewGroup(char[] arg1,int arg2,int arg3);
    public A addNewGroup(byte[] arg1,int arg2,int arg3);
    public A addNewGroup(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewGroup(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> editMetadata();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public Integer getPriority();
    public A withPriority(Integer priority);
    public Boolean hasPriority();
    public A withNewPriority(int arg0);
    public Boolean getReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public Boolean hasReadOnlyRootFilesystem();
    public A withNewReadOnlyRootFilesystem(String arg1);
    public A withNewReadOnlyRootFilesystem(boolean arg1);
    public A addToRequiredDropCapabilities(int index,String item);
    public A setToRequiredDropCapabilities(int index,String item);
    public A addToRequiredDropCapabilities(String... items);
    public A addAllToRequiredDropCapabilities(Collection<String> items);
    public A removeFromRequiredDropCapabilities(String... items);
    public A removeAllFromRequiredDropCapabilities(Collection<String> items);
    public List<String> getRequiredDropCapabilities();
    public String getRequiredDropCapability(int index);
    public String getFirstRequiredDropCapability();
    public String getLastRequiredDropCapability();
    public String getMatchingRequiredDropCapability(Predicate<String> predicate);
    public Boolean hasMatchingRequiredDropCapability(Predicate<String> predicate);
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities);
    public A withRequiredDropCapabilities(String... requiredDropCapabilities);
    public Boolean hasRequiredDropCapabilities();
    public A addNewRequiredDropCapability(StringBuilder arg1);
    public A addNewRequiredDropCapability(int[] arg1,int arg2,int arg3);
    public A addNewRequiredDropCapability(char[] arg1);
    public A addNewRequiredDropCapability(StringBuffer arg1);
    public A addNewRequiredDropCapability(byte[] arg1,int arg2);
    public A addNewRequiredDropCapability(byte[] arg1);
    public A addNewRequiredDropCapability(char[] arg1,int arg2,int arg3);
    public A addNewRequiredDropCapability(byte[] arg1,int arg2,int arg3);
    public A addNewRequiredDropCapability(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewRequiredDropCapability(String arg1);
    
/**
 * This method has been deprecated, please use method buildRunAsUser instead.
 * @return The buildable object.
 */
@Deprecated public RunAsUserStrategyOptions getRunAsUser();
    public RunAsUserStrategyOptions buildRunAsUser();
    public A withRunAsUser(RunAsUserStrategyOptions runAsUser);
    public Boolean hasRunAsUser();
    public A withNewRunAsUser(String type,Long uid,Long uidRangeMax,Long uidRangeMin);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUser();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item);
    
/**
 * This method has been deprecated, please use method buildSeLinuxContext instead.
 * @return The buildable object.
 */
@Deprecated public SELinuxContextStrategyOptions getSeLinuxContext();
    public SELinuxContextStrategyOptions buildSeLinuxContext();
    public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext);
    public Boolean hasSeLinuxContext();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContext();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContextLike(SELinuxContextStrategyOptions item);
    public A addToSeccompProfiles(int index,String item);
    public A setToSeccompProfiles(int index,String item);
    public A addToSeccompProfiles(String... items);
    public A addAllToSeccompProfiles(Collection<String> items);
    public A removeFromSeccompProfiles(String... items);
    public A removeAllFromSeccompProfiles(Collection<String> items);
    public List<String> getSeccompProfiles();
    public String getSeccompProfile(int index);
    public String getFirstSeccompProfile();
    public String getLastSeccompProfile();
    public String getMatchingSeccompProfile(Predicate<String> predicate);
    public Boolean hasMatchingSeccompProfile(Predicate<String> predicate);
    public A withSeccompProfiles(List<String> seccompProfiles);
    public A withSeccompProfiles(String... seccompProfiles);
    public Boolean hasSeccompProfiles();
    public A addNewSeccompProfile(StringBuilder arg1);
    public A addNewSeccompProfile(int[] arg1,int arg2,int arg3);
    public A addNewSeccompProfile(char[] arg1);
    public A addNewSeccompProfile(StringBuffer arg1);
    public A addNewSeccompProfile(byte[] arg1,int arg2);
    public A addNewSeccompProfile(byte[] arg1);
    public A addNewSeccompProfile(char[] arg1,int arg2,int arg3);
    public A addNewSeccompProfile(byte[] arg1,int arg2,int arg3);
    public A addNewSeccompProfile(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewSeccompProfile(String arg1);
    
/**
 * This method has been deprecated, please use method buildSupplementalGroups instead.
 * @return The buildable object.
 */
@Deprecated public SupplementalGroupsStrategyOptions getSupplementalGroups();
    public SupplementalGroupsStrategyOptions buildSupplementalGroups();
    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups);
    public Boolean hasSupplementalGroups();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups();
    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
    public A addToUsers(int index,String item);
    public A setToUsers(int index,String item);
    public A addToUsers(String... items);
    public A addAllToUsers(Collection<String> items);
    public A removeFromUsers(String... items);
    public A removeAllFromUsers(Collection<String> items);
    public List<String> getUsers();
    public String getUser(int index);
    public String getFirstUser();
    public String getLastUser();
    public String getMatchingUser(Predicate<String> predicate);
    public Boolean hasMatchingUser(Predicate<String> predicate);
    public A withUsers(List<String> users);
    public A withUsers(String... users);
    public Boolean hasUsers();
    public A addNewUser(StringBuilder arg1);
    public A addNewUser(int[] arg1,int arg2,int arg3);
    public A addNewUser(char[] arg1);
    public A addNewUser(StringBuffer arg1);
    public A addNewUser(byte[] arg1,int arg2);
    public A addNewUser(byte[] arg1);
    public A addNewUser(char[] arg1,int arg2,int arg3);
    public A addNewUser(byte[] arg1,int arg2,int arg3);
    public A addNewUser(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewUser(String arg1);
    public A addToVolumes(int index,String item);
    public A setToVolumes(int index,String item);
    public A addToVolumes(String... items);
    public A addAllToVolumes(Collection<String> items);
    public A removeFromVolumes(String... items);
    public A removeAllFromVolumes(Collection<String> items);
    public List<String> getVolumes();
    public String getVolume(int index);
    public String getFirstVolume();
    public String getLastVolume();
    public String getMatchingVolume(Predicate<String> predicate);
    public Boolean hasMatchingVolume(Predicate<String> predicate);
    public A withVolumes(List<String> volumes);
    public A withVolumes(String... volumes);
    public Boolean hasVolumes();
    public A addNewVolume(StringBuilder arg1);
    public A addNewVolume(int[] arg1,int arg2,int arg3);
    public A addNewVolume(char[] arg1);
    public A addNewVolume(StringBuffer arg1);
    public A addNewVolume(byte[] arg1,int arg2);
    public A addNewVolume(byte[] arg1);
    public A addNewVolume(char[] arg1,int arg2,int arg3);
    public A addNewVolume(byte[] arg1,int arg2,int arg3);
    public A addNewVolume(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewVolume(String arg1);
    public interface AllowedFlexVolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AllowedFlexVolumeFluent<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<N>> {

            public N and();
            public N endAllowedFlexVolume();    }


    public interface FsGroupNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FSGroupStrategyOptionsFluent<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<N>> {

            public N and();
            public N endFsGroup();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface RunAsUserNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RunAsUserStrategyOptionsFluent<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<N>> {

            public N and();
            public N endRunAsUser();    }


    public interface SeLinuxContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SELinuxContextStrategyOptionsFluent<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<N>> {

            public N and();
            public N endSeLinuxContext();    }


    public interface SupplementalGroupsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SupplementalGroupsStrategyOptionsFluent<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<N>> {

            public N and();
            public N endSupplementalGroups();    }


}
