package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReleaseBuilder extends ReleaseFluentImpl<ReleaseBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Release,ReleaseBuilder> {

    ReleaseFluent<?> fluent;
    Boolean validationEnabled;

    public ReleaseBuilder() {
        this(true);
    }

    public ReleaseBuilder(Boolean validationEnabled) {
        this(new Release(), validationEnabled);
    }

    public ReleaseBuilder(ReleaseFluent<?> fluent) {
        this(fluent, true);
    }

    public ReleaseBuilder(ReleaseFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Release(), validationEnabled);
    }

    public ReleaseBuilder(ReleaseFluent<?> fluent,Release instance) {
        this(fluent, instance, true);
    }

    public ReleaseBuilder(ReleaseFluent<?> fluent,Release instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withChannels(instance.getChannels()); 
        fluent.withImage(instance.getImage()); 
        fluent.withUrl(instance.getUrl()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public ReleaseBuilder(Release instance) {
        this(instance,true);
    }

    public ReleaseBuilder(Release instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withChannels(instance.getChannels()); 
        this.withImage(instance.getImage()); 
        this.withUrl(instance.getUrl()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public Release build() {
        Release buildable = new Release(fluent.getChannels(),fluent.getImage(),fluent.getUrl(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ReleaseBuilder that = (ReleaseBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
