package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyBuilder extends ProxyFluentImpl<ProxyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Proxy,ProxyBuilder> {

    ProxyFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyBuilder() {
        this(true);
    }

    public ProxyBuilder(Boolean validationEnabled) {
        this(new Proxy(), validationEnabled);
    }

    public ProxyBuilder(ProxyFluent<?> fluent) {
        this(fluent, true);
    }

    public ProxyBuilder(ProxyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Proxy(), validationEnabled);
    }

    public ProxyBuilder(ProxyFluent<?> fluent,Proxy instance) {
        this(fluent, instance, true);
    }

    public ProxyBuilder(ProxyFluent<?> fluent,Proxy instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ProxyBuilder(Proxy instance) {
        this(instance,true);
    }

    public ProxyBuilder(Proxy instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public Proxy build() {
        Proxy buildable = new Proxy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProxyBuilder that = (ProxyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
