package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class OperandVersionFluentImpl<A extends OperandVersionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OperandVersionFluent<A> {

    private String name;
    private String version;

    public OperandVersionFluentImpl() {
    }

    public OperandVersionFluentImpl(OperandVersion instance) {
        this.withName(instance.getName()); 
        this.withVersion(instance.getVersion()); 
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OperandVersionFluentImpl that = (OperandVersionFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  version,  super.hashCode());
    }

}
