package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OAuthListFluent<A extends OAuthListFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,OAuth item);
    public A setToItems(int index,OAuth item);
    public A addToItems(OAuth... items);
    public A addAllToItems(Collection<OAuth> items);
    public A removeFromItems(OAuth... items);
    public A removeAllFromItems(Collection<OAuth> items);
    public A removeMatchingFromItems(Predicate<OAuthBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<OAuth> getItems();
    public List<OAuth> buildItems();
    public OAuth buildItem(int index);
    public OAuth buildFirstItem();
    public OAuth buildLastItem();
    public OAuth buildMatchingItem(Predicate<OAuthBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<OAuthBuilder> predicate);
    public A withItems(List<OAuth> items);
    public A withItems(OAuth... items);
    public Boolean hasItems();
    public io.fabric8.openshift.api.model.OAuthListFluent.ItemsNested<A> addNewItem();
    public io.fabric8.openshift.api.model.OAuthListFluent.ItemsNested<A> addNewItemLike(OAuth item);
    public io.fabric8.openshift.api.model.OAuthListFluent.ItemsNested<A> setNewItemLike(int index,OAuth item);
    public io.fabric8.openshift.api.model.OAuthListFluent.ItemsNested<A> editItem(int index);
    public io.fabric8.openshift.api.model.OAuthListFluent.ItemsNested<A> editFirstItem();
    public io.fabric8.openshift.api.model.OAuthListFluent.ItemsNested<A> editLastItem();
    public io.fabric8.openshift.api.model.OAuthListFluent.ItemsNested<A> editMatchingItem(Predicate<OAuthBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthFluent<io.fabric8.openshift.api.model.OAuthListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
