package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LDAPAttributeMappingBuilder extends LDAPAttributeMappingFluentImpl<LDAPAttributeMappingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<LDAPAttributeMapping,LDAPAttributeMappingBuilder> {

    LDAPAttributeMappingFluent<?> fluent;
    Boolean validationEnabled;

    public LDAPAttributeMappingBuilder() {
        this(true);
    }

    public LDAPAttributeMappingBuilder(Boolean validationEnabled) {
        this(new LDAPAttributeMapping(), validationEnabled);
    }

    public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent) {
        this(fluent, true);
    }

    public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new LDAPAttributeMapping(), validationEnabled);
    }

    public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent,LDAPAttributeMapping instance) {
        this(fluent, instance, true);
    }

    public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent,LDAPAttributeMapping instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withEmail(instance.getEmail()); 
        fluent.withId(instance.getId()); 
        fluent.withName(instance.getName()); 
        fluent.withPreferredUsername(instance.getPreferredUsername()); 
        this.validationEnabled = validationEnabled; 
    }

    public LDAPAttributeMappingBuilder(LDAPAttributeMapping instance) {
        this(instance,true);
    }

    public LDAPAttributeMappingBuilder(LDAPAttributeMapping instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withEmail(instance.getEmail()); 
        this.withId(instance.getId()); 
        this.withName(instance.getName()); 
        this.withPreferredUsername(instance.getPreferredUsername()); 
        this.validationEnabled = validationEnabled; 
    }

    public LDAPAttributeMapping build() {
        LDAPAttributeMapping buildable = new LDAPAttributeMapping(fluent.getEmail(),fluent.getId(),fluent.getName(),fluent.getPreferredUsername());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LDAPAttributeMappingBuilder that = (LDAPAttributeMappingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
