package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntermediateTLSProfileBuilder extends IntermediateTLSProfileFluentImpl<IntermediateTLSProfileBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntermediateTLSProfile,IntermediateTLSProfileBuilder> {

    IntermediateTLSProfileFluent<?> fluent;
    Boolean validationEnabled;

    public IntermediateTLSProfileBuilder() {
        this(true);
    }

    public IntermediateTLSProfileBuilder(Boolean validationEnabled) {
        this(new IntermediateTLSProfile(), validationEnabled);
    }

    public IntermediateTLSProfileBuilder(IntermediateTLSProfileFluent<?> fluent) {
        this(fluent, true);
    }

    public IntermediateTLSProfileBuilder(IntermediateTLSProfileFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntermediateTLSProfile(), validationEnabled);
    }

    public IntermediateTLSProfileBuilder(IntermediateTLSProfileFluent<?> fluent,IntermediateTLSProfile instance) {
        this(fluent, instance, true);
    }

    public IntermediateTLSProfileBuilder(IntermediateTLSProfileFluent<?> fluent,IntermediateTLSProfile instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public IntermediateTLSProfileBuilder(IntermediateTLSProfile instance) {
        this(instance,true);
    }

    public IntermediateTLSProfileBuilder(IntermediateTLSProfile instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public IntermediateTLSProfile build() {
        IntermediateTLSProfile buildable = new IntermediateTLSProfile();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntermediateTLSProfileBuilder that = (IntermediateTLSProfileBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
