package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InfrastructureListBuilder extends InfrastructureListFluentImpl<InfrastructureListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<InfrastructureList,InfrastructureListBuilder> {

    InfrastructureListFluent<?> fluent;
    Boolean validationEnabled;

    public InfrastructureListBuilder() {
        this(true);
    }

    public InfrastructureListBuilder(Boolean validationEnabled) {
        this(new InfrastructureList(), validationEnabled);
    }

    public InfrastructureListBuilder(InfrastructureListFluent<?> fluent) {
        this(fluent, true);
    }

    public InfrastructureListBuilder(InfrastructureListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new InfrastructureList(), validationEnabled);
    }

    public InfrastructureListBuilder(InfrastructureListFluent<?> fluent,InfrastructureList instance) {
        this(fluent, instance, true);
    }

    public InfrastructureListBuilder(InfrastructureListFluent<?> fluent,InfrastructureList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public InfrastructureListBuilder(InfrastructureList instance) {
        this(instance,true);
    }

    public InfrastructureListBuilder(InfrastructureList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public InfrastructureList build() {
        InfrastructureList buildable = new InfrastructureList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InfrastructureListBuilder that = (InfrastructureListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
