package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ImageStreamListFluent<A extends ImageStreamListFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,ImageStream item);
    public A setToItems(int index,ImageStream item);
    public A addToItems(ImageStream... items);
    public A addAllToItems(Collection<ImageStream> items);
    public A removeFromItems(ImageStream... items);
    public A removeAllFromItems(Collection<ImageStream> items);
    public A removeMatchingFromItems(Predicate<ImageStreamBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ImageStream> getItems();
    public List<ImageStream> buildItems();
    public ImageStream buildItem(int index);
    public ImageStream buildFirstItem();
    public ImageStream buildLastItem();
    public ImageStream buildMatchingItem(Predicate<ImageStreamBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ImageStreamBuilder> predicate);
    public A withItems(List<ImageStream> items);
    public A withItems(ImageStream... items);
    public Boolean hasItems();
    public io.fabric8.openshift.api.model.ImageStreamListFluent.ItemsNested<A> addNewItem();
    public io.fabric8.openshift.api.model.ImageStreamListFluent.ItemsNested<A> addNewItemLike(ImageStream item);
    public io.fabric8.openshift.api.model.ImageStreamListFluent.ItemsNested<A> setNewItemLike(int index,ImageStream item);
    public io.fabric8.openshift.api.model.ImageStreamListFluent.ItemsNested<A> editItem(int index);
    public io.fabric8.openshift.api.model.ImageStreamListFluent.ItemsNested<A> editFirstItem();
    public io.fabric8.openshift.api.model.ImageStreamListFluent.ItemsNested<A> editLastItem();
    public io.fabric8.openshift.api.model.ImageStreamListFluent.ItemsNested<A> editMatchingItem(Predicate<ImageStreamBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<io.fabric8.openshift.api.model.ImageStreamListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
