package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageStreamImageBuilder extends ImageStreamImageFluentImpl<ImageStreamImageBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ImageStreamImage,ImageStreamImageBuilder> {

    ImageStreamImageFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamImageBuilder() {
        this(true);
    }

    public ImageStreamImageBuilder(Boolean validationEnabled) {
        this(new ImageStreamImage(), validationEnabled);
    }

    public ImageStreamImageBuilder(ImageStreamImageFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageStreamImageBuilder(ImageStreamImageFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ImageStreamImage(), validationEnabled);
    }

    public ImageStreamImageBuilder(ImageStreamImageFluent<?> fluent,ImageStreamImage instance) {
        this(fluent, instance, true);
    }

    public ImageStreamImageBuilder(ImageStreamImageFluent<?> fluent,ImageStreamImage instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withImage(instance.getImage()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageStreamImageBuilder(ImageStreamImage instance) {
        this(instance,true);
    }

    public ImageStreamImageBuilder(ImageStreamImage instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withImage(instance.getImage()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageStreamImage build() {
        ImageStreamImage buildable = new ImageStreamImage(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageStreamImageBuilder that = (ImageStreamImageBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
