package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ImageSignatureFluent<A extends ImageSignatureFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToConditions(int index,SignatureCondition item);
    public A setToConditions(int index,SignatureCondition item);
    public A addToConditions(SignatureCondition... items);
    public A addAllToConditions(Collection<SignatureCondition> items);
    public A removeFromConditions(SignatureCondition... items);
    public A removeAllFromConditions(Collection<SignatureCondition> items);
    public A removeMatchingFromConditions(Predicate<SignatureConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<SignatureCondition> getConditions();
    public List<SignatureCondition> buildConditions();
    public SignatureCondition buildCondition(int index);
    public SignatureCondition buildFirstCondition();
    public SignatureCondition buildLastCondition();
    public SignatureCondition buildMatchingCondition(Predicate<SignatureConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<SignatureConditionBuilder> predicate);
    public A withConditions(List<SignatureCondition> conditions);
    public A withConditions(SignatureCondition... conditions);
    public Boolean hasConditions();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> addNewConditionLike(SignatureCondition item);
    public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> setNewConditionLike(int index,SignatureCondition item);
    public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> editMatchingCondition(Predicate<SignatureConditionBuilder> predicate);
    public String getContent();
    public A withContent(String content);
    public Boolean hasContent();
    public A withNewContent(StringBuilder arg1);
    public A withNewContent(int[] arg1,int arg2,int arg3);
    public A withNewContent(char[] arg1);
    public A withNewContent(StringBuffer arg1);
    public A withNewContent(byte[] arg1,int arg2);
    public A withNewContent(byte[] arg1);
    public A withNewContent(char[] arg1,int arg2,int arg3);
    public A withNewContent(byte[] arg1,int arg2,int arg3);
    public A withNewContent(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewContent(String arg1);
    public String getCreated();
    public A withCreated(String created);
    public Boolean hasCreated();
    public A withNewCreated(StringBuilder arg1);
    public A withNewCreated(int[] arg1,int arg2,int arg3);
    public A withNewCreated(char[] arg1);
    public A withNewCreated(StringBuffer arg1);
    public A withNewCreated(byte[] arg1,int arg2);
    public A withNewCreated(byte[] arg1);
    public A withNewCreated(char[] arg1,int arg2,int arg3);
    public A withNewCreated(byte[] arg1,int arg2,int arg3);
    public A withNewCreated(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewCreated(String arg1);
    public String getImageIdentity();
    public A withImageIdentity(String imageIdentity);
    public Boolean hasImageIdentity();
    public A withNewImageIdentity(StringBuilder arg1);
    public A withNewImageIdentity(int[] arg1,int arg2,int arg3);
    public A withNewImageIdentity(char[] arg1);
    public A withNewImageIdentity(StringBuffer arg1);
    public A withNewImageIdentity(byte[] arg1,int arg2);
    public A withNewImageIdentity(byte[] arg1);
    public A withNewImageIdentity(char[] arg1,int arg2,int arg3);
    public A withNewImageIdentity(byte[] arg1,int arg2,int arg3);
    public A withNewImageIdentity(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImageIdentity(String arg1);
    
/**
 * This method has been deprecated, please use method buildIssuedBy instead.
 * @return The buildable object.
 */
@Deprecated public SignatureIssuer getIssuedBy();
    public SignatureIssuer buildIssuedBy();
    public A withIssuedBy(SignatureIssuer issuedBy);
    public Boolean hasIssuedBy();
    public A withNewIssuedBy(String commonName,String organization);
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> withNewIssuedBy();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> withNewIssuedByLike(SignatureIssuer item);
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> editIssuedBy();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedBy();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedByLike(SignatureIssuer item);
    
/**
 * This method has been deprecated, please use method buildIssuedTo instead.
 * @return The buildable object.
 */
@Deprecated public SignatureSubject getIssuedTo();
    public SignatureSubject buildIssuedTo();
    public A withIssuedTo(SignatureSubject issuedTo);
    public Boolean hasIssuedTo();
    public A withNewIssuedTo(String commonName,String organization,String publicKeyID);
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> withNewIssuedTo();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> withNewIssuedToLike(SignatureSubject item);
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> editIssuedTo();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedTo();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedToLike(SignatureSubject item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> editMetadata();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToSignedClaims(String key,String value);
    public A addToSignedClaims(java.util.Map<String,String> map);
    public A removeFromSignedClaims(String key);
    public A removeFromSignedClaims(java.util.Map<String,String> map);
    public java.util.Map<String,String> getSignedClaims();
    public <K extends Object,V extends Object>A withSignedClaims(java.util.Map<String,String> signedClaims);
    public Boolean hasSignedClaims();
    public String getType();
    public A withType(String type);
    public Boolean hasType();
    public A withNewType(StringBuilder arg1);
    public A withNewType(int[] arg1,int arg2,int arg3);
    public A withNewType(char[] arg1);
    public A withNewType(StringBuffer arg1);
    public A withNewType(byte[] arg1,int arg2);
    public A withNewType(byte[] arg1);
    public A withNewType(char[] arg1,int arg2,int arg3);
    public A withNewType(byte[] arg1,int arg2,int arg3);
    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewType(String arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SignatureConditionFluent<io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface IssuedByNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SignatureIssuerFluent<io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<N>> {

            public N and();
            public N endIssuedBy();    }


    public interface IssuedToNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SignatureSubjectFluent<io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<N>> {

            public N and();
            public N endIssuedTo();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
