package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IdentityProviderBuilder extends IdentityProviderFluentImpl<IdentityProviderBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IdentityProvider,IdentityProviderBuilder> {

    IdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public IdentityProviderBuilder() {
        this(true);
    }

    public IdentityProviderBuilder(Boolean validationEnabled) {
        this(new IdentityProvider(), validationEnabled);
    }

    public IdentityProviderBuilder(IdentityProviderFluent<?> fluent) {
        this(fluent, true);
    }

    public IdentityProviderBuilder(IdentityProviderFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IdentityProvider(), validationEnabled);
    }

    public IdentityProviderBuilder(IdentityProviderFluent<?> fluent,IdentityProvider instance) {
        this(fluent, instance, true);
    }

    public IdentityProviderBuilder(IdentityProviderFluent<?> fluent,IdentityProvider instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBasicAuth(instance.getBasicAuth()); 
        fluent.withGithub(instance.getGithub()); 
        fluent.withGitlab(instance.getGitlab()); 
        fluent.withGoogle(instance.getGoogle()); 
        fluent.withHtpasswd(instance.getHtpasswd()); 
        fluent.withKeystone(instance.getKeystone()); 
        fluent.withLdap(instance.getLdap()); 
        fluent.withMappingMethod(instance.getMappingMethod()); 
        fluent.withName(instance.getName()); 
        fluent.withOpenID(instance.getOpenID()); 
        fluent.withRequestHeader(instance.getRequestHeader()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public IdentityProviderBuilder(IdentityProvider instance) {
        this(instance,true);
    }

    public IdentityProviderBuilder(IdentityProvider instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBasicAuth(instance.getBasicAuth()); 
        this.withGithub(instance.getGithub()); 
        this.withGitlab(instance.getGitlab()); 
        this.withGoogle(instance.getGoogle()); 
        this.withHtpasswd(instance.getHtpasswd()); 
        this.withKeystone(instance.getKeystone()); 
        this.withLdap(instance.getLdap()); 
        this.withMappingMethod(instance.getMappingMethod()); 
        this.withName(instance.getName()); 
        this.withOpenID(instance.getOpenID()); 
        this.withRequestHeader(instance.getRequestHeader()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public IdentityProvider build() {
        IdentityProvider buildable = new IdentityProvider(fluent.getBasicAuth(),fluent.getGithub(),fluent.getGitlab(),fluent.getGoogle(),fluent.getHtpasswd(),fluent.getKeystone(),fluent.getLdap(),fluent.getMappingMethod(),fluent.getName(),fluent.getOpenID(),fluent.getRequestHeader(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IdentityProviderBuilder that = (IdentityProviderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
