package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class GitHubIdentityProviderFluentImpl<A extends GitHubIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GitHubIdentityProviderFluent<A> {

    private ConfigMapNameReferenceBuilder ca;
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String hostname;
    private List<String> organizations = new ArrayList<String>();
    private List<String> teams = new ArrayList<String>();

    public GitHubIdentityProviderFluentImpl() {
    }

    public GitHubIdentityProviderFluentImpl(GitHubIdentityProvider instance) {
        this.withCa(instance.getCa()); 
        this.withClientID(instance.getClientID()); 
        this.withClientSecret(instance.getClientSecret()); 
        this.withHostname(instance.getHostname()); 
        this.withOrganizations(instance.getOrganizations()); 
        this.withTeams(instance.getTeams()); 
    }

    
/**
 * This method has been deprecated, please use method buildCa instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public ConfigMapNameReference buildCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public A withCa(ConfigMapNameReference ca) {
        _visitables.get("ca").remove(this.ca);
        if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public Boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(String name) {
        return (A)withCa(new ConfigMapNameReference(name));
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> withNewCa() {
        return new CaNestedImpl();
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> editCa() {
        return withNewCaLike(getCa());
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> editOrNewCa() {
        return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return withNewCaLike(getCa() != null ? getCa(): item);
    }

    public String getClientID() {
        return this.clientID;
    }

    public A withClientID(String clientID) {
        this.clientID=clientID; return (A) this;
    }

    public Boolean hasClientID() {
        return this.clientID != null;
    }

    public A withNewClientID(StringBuilder arg1) {
        return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(int[] arg1,int arg2,int arg3) {
        return (A)withClientID(new String(arg1, arg2, arg3));
    }

    public A withNewClientID(char[] arg1) {
        return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(StringBuffer arg1) {
        return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(byte[] arg1,int arg2) {
        return (A)withClientID(new String(arg1, arg2));
    }

    public A withNewClientID(byte[] arg1) {
        return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(char[] arg1,int arg2,int arg3) {
        return (A)withClientID(new String(arg1, arg2, arg3));
    }

    public A withNewClientID(byte[] arg1,int arg2,int arg3) {
        return (A)withClientID(new String(arg1, arg2, arg3));
    }

    public A withNewClientID(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withClientID(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewClientID(String arg1) {
        return (A)withClientID(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public SecretNameReference buildClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(SecretNameReference clientSecret) {
        _visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret!=null){ this.clientSecret= new SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(String name) {
        return (A)withClientSecret(new SecretNameReference(name));
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
        return withNewClientSecretLike(getClientSecret());
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new SecretNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname() {
        return this.hostname != null;
    }

    public A withNewHostname(StringBuilder arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(int[] arg1,int arg2,int arg3) {
        return (A)withHostname(new String(arg1, arg2, arg3));
    }

    public A withNewHostname(char[] arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuffer arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(byte[] arg1,int arg2) {
        return (A)withHostname(new String(arg1, arg2));
    }

    public A withNewHostname(byte[] arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(char[] arg1,int arg2,int arg3) {
        return (A)withHostname(new String(arg1, arg2, arg3));
    }

    public A withNewHostname(byte[] arg1,int arg2,int arg3) {
        return (A)withHostname(new String(arg1, arg2, arg3));
    }

    public A withNewHostname(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHostname(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHostname(String arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A addToOrganizations(int index,String item) {
        if (this.organizations == null) {this.organizations = new ArrayList<String>();}
        this.organizations.add(index, item);
        return (A)this;
    }

    public A setToOrganizations(int index,String item) {
        if (this.organizations == null) {this.organizations = new ArrayList<String>();}
        this.organizations.set(index, item); return (A)this;
    }

    public A addToOrganizations(String... items) {
        if (this.organizations == null) {this.organizations = new ArrayList<String>();}
        for (String item : items) {this.organizations.add(item);} return (A)this;
    }

    public A addAllToOrganizations(Collection<String> items) {
        if (this.organizations == null) {this.organizations = new ArrayList<String>();}
        for (String item : items) {this.organizations.add(item);} return (A)this;
    }

    public A removeFromOrganizations(String... items) {
        for (String item : items) {if (this.organizations!= null){ this.organizations.remove(item);}} return (A)this;
    }

    public A removeAllFromOrganizations(Collection<String> items) {
        for (String item : items) {if (this.organizations!= null){ this.organizations.remove(item);}} return (A)this;
    }

    public List<String> getOrganizations() {
        return this.organizations;
    }

    public String getOrganization(int index) {
        return this.organizations.get(index);
    }

    public String getFirstOrganization() {
        return this.organizations.get(0);
    }

    public String getLastOrganization() {
        return this.organizations.get(organizations.size() - 1);
    }

    public String getMatchingOrganization(Predicate<String> predicate) {
        for (String item: organizations) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingOrganization(Predicate<String> predicate) {
        for (String item: organizations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withOrganizations(List<String> organizations) {
        if (this.organizations != null) { _visitables.get("organizations").removeAll(this.organizations);}
        if (organizations != null) {this.organizations = new ArrayList<String>(); for (String item : organizations){this.addToOrganizations(item);}} else { this.organizations = null;} return (A) this;
    }

    public A withOrganizations(String... organizations) {
        if (this.organizations != null) {this.organizations.clear();}
        if (organizations != null) {for (String item :organizations){ this.addToOrganizations(item);}} return (A) this;
    }

    public Boolean hasOrganizations() {
        return organizations != null && !organizations.isEmpty();
    }

    public A addNewOrganization(StringBuilder arg1) {
        return (A)addToOrganizations(new String(arg1));
    }

    public A addNewOrganization(int[] arg1,int arg2,int arg3) {
        return (A)addToOrganizations(new String(arg1, arg2, arg3));
    }

    public A addNewOrganization(char[] arg1) {
        return (A)addToOrganizations(new String(arg1));
    }

    public A addNewOrganization(StringBuffer arg1) {
        return (A)addToOrganizations(new String(arg1));
    }

    public A addNewOrganization(byte[] arg1,int arg2) {
        return (A)addToOrganizations(new String(arg1, arg2));
    }

    public A addNewOrganization(byte[] arg1) {
        return (A)addToOrganizations(new String(arg1));
    }

    public A addNewOrganization(char[] arg1,int arg2,int arg3) {
        return (A)addToOrganizations(new String(arg1, arg2, arg3));
    }

    public A addNewOrganization(byte[] arg1,int arg2,int arg3) {
        return (A)addToOrganizations(new String(arg1, arg2, arg3));
    }

    public A addNewOrganization(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToOrganizations(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewOrganization(String arg1) {
        return (A)addToOrganizations(new String(arg1));
    }

    public A addToTeams(int index,String item) {
        if (this.teams == null) {this.teams = new ArrayList<String>();}
        this.teams.add(index, item);
        return (A)this;
    }

    public A setToTeams(int index,String item) {
        if (this.teams == null) {this.teams = new ArrayList<String>();}
        this.teams.set(index, item); return (A)this;
    }

    public A addToTeams(String... items) {
        if (this.teams == null) {this.teams = new ArrayList<String>();}
        for (String item : items) {this.teams.add(item);} return (A)this;
    }

    public A addAllToTeams(Collection<String> items) {
        if (this.teams == null) {this.teams = new ArrayList<String>();}
        for (String item : items) {this.teams.add(item);} return (A)this;
    }

    public A removeFromTeams(String... items) {
        for (String item : items) {if (this.teams!= null){ this.teams.remove(item);}} return (A)this;
    }

    public A removeAllFromTeams(Collection<String> items) {
        for (String item : items) {if (this.teams!= null){ this.teams.remove(item);}} return (A)this;
    }

    public List<String> getTeams() {
        return this.teams;
    }

    public String getTeam(int index) {
        return this.teams.get(index);
    }

    public String getFirstTeam() {
        return this.teams.get(0);
    }

    public String getLastTeam() {
        return this.teams.get(teams.size() - 1);
    }

    public String getMatchingTeam(Predicate<String> predicate) {
        for (String item: teams) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTeam(Predicate<String> predicate) {
        for (String item: teams) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTeams(List<String> teams) {
        if (this.teams != null) { _visitables.get("teams").removeAll(this.teams);}
        if (teams != null) {this.teams = new ArrayList<String>(); for (String item : teams){this.addToTeams(item);}} else { this.teams = null;} return (A) this;
    }

    public A withTeams(String... teams) {
        if (this.teams != null) {this.teams.clear();}
        if (teams != null) {for (String item :teams){ this.addToTeams(item);}} return (A) this;
    }

    public Boolean hasTeams() {
        return teams != null && !teams.isEmpty();
    }

    public A addNewTeam(StringBuilder arg1) {
        return (A)addToTeams(new String(arg1));
    }

    public A addNewTeam(int[] arg1,int arg2,int arg3) {
        return (A)addToTeams(new String(arg1, arg2, arg3));
    }

    public A addNewTeam(char[] arg1) {
        return (A)addToTeams(new String(arg1));
    }

    public A addNewTeam(StringBuffer arg1) {
        return (A)addToTeams(new String(arg1));
    }

    public A addNewTeam(byte[] arg1,int arg2) {
        return (A)addToTeams(new String(arg1, arg2));
    }

    public A addNewTeam(byte[] arg1) {
        return (A)addToTeams(new String(arg1));
    }

    public A addNewTeam(char[] arg1,int arg2,int arg3) {
        return (A)addToTeams(new String(arg1, arg2, arg3));
    }

    public A addNewTeam(byte[] arg1,int arg2,int arg3) {
        return (A)addToTeams(new String(arg1, arg2, arg3));
    }

    public A addNewTeam(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToTeams(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewTeam(String arg1) {
        return (A)addToTeams(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GitHubIdentityProviderFluentImpl that = (GitHubIdentityProviderFluentImpl) o;
        if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
        if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
        if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
        if (organizations != null ? !organizations.equals(that.organizations) :that.organizations != null) return false;
        if (teams != null ? !teams.equals(that.teams) :that.teams != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ca,  clientID,  clientSecret,  hostname,  organizations,  teams,  super.hashCode());
    }

    public class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<N>> implements io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapNameReferenceBuilder builder;

            CaNestedImpl(ConfigMapNameReference item) {
                this.builder = new ConfigMapNameReferenceBuilder(this, item);
                        
            }

            CaNestedImpl() {
                this.builder = new ConfigMapNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) GitHubIdentityProviderFluentImpl.this.withCa(builder.build());
            }

            public N endCa() {
                return and();
            }
    }


    public class ClientSecretNestedImpl<N> extends SecretNameReferenceFluentImpl<io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<N>> implements io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

            ClientSecretNestedImpl(SecretNameReference item) {
                this.builder = new SecretNameReferenceBuilder(this, item);
                        
            }

            ClientSecretNestedImpl() {
                this.builder = new SecretNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) GitHubIdentityProviderFluentImpl.this.withClientSecret(builder.build());
            }

            public N endClientSecret() {
                return and();
            }
    }


}
