package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FeatureGateStatusBuilder extends FeatureGateStatusFluentImpl<FeatureGateStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<FeatureGateStatus,FeatureGateStatusBuilder> {

    FeatureGateStatusFluent<?> fluent;
    Boolean validationEnabled;

    public FeatureGateStatusBuilder() {
        this(true);
    }

    public FeatureGateStatusBuilder(Boolean validationEnabled) {
        this(new FeatureGateStatus(), validationEnabled);
    }

    public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new FeatureGateStatus(), validationEnabled);
    }

    public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,FeatureGateStatus instance) {
        this(fluent, instance, true);
    }

    public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,FeatureGateStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public FeatureGateStatusBuilder(FeatureGateStatus instance) {
        this(instance,true);
    }

    public FeatureGateStatusBuilder(FeatureGateStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public FeatureGateStatus build() {
        FeatureGateStatus buildable = new FeatureGateStatus();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FeatureGateStatusBuilder that = (FeatureGateStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
