package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DeploymentTriggerPolicyFluentImpl<A extends DeploymentTriggerPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentTriggerPolicyFluent<A> {

    private DeploymentTriggerImageChangeParamsBuilder imageChangeParams;
    private String type;

    public DeploymentTriggerPolicyFluentImpl() {
    }

    public DeploymentTriggerPolicyFluentImpl(DeploymentTriggerPolicy instance) {
        this.withImageChangeParams(instance.getImageChangeParams()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildImageChangeParams instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentTriggerImageChangeParams getImageChangeParams() {
        return this.imageChangeParams!=null?this.imageChangeParams.build():null;
    }

    public DeploymentTriggerImageChangeParams buildImageChangeParams() {
        return this.imageChangeParams!=null?this.imageChangeParams.build():null;
    }

    public A withImageChangeParams(DeploymentTriggerImageChangeParams imageChangeParams) {
        _visitables.get("imageChangeParams").remove(this.imageChangeParams);
        if (imageChangeParams!=null){ this.imageChangeParams= new DeploymentTriggerImageChangeParamsBuilder(imageChangeParams); _visitables.get("imageChangeParams").add(this.imageChangeParams);} return (A) this;
    }

    public Boolean hasImageChangeParams() {
        return this.imageChangeParams != null;
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent.ImageChangeParamsNested<A> withNewImageChangeParams() {
        return new ImageChangeParamsNestedImpl();
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent.ImageChangeParamsNested<A> withNewImageChangeParamsLike(DeploymentTriggerImageChangeParams item) {
        return new ImageChangeParamsNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent.ImageChangeParamsNested<A> editImageChangeParams() {
        return withNewImageChangeParamsLike(getImageChangeParams());
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent.ImageChangeParamsNested<A> editOrNewImageChangeParams() {
        return withNewImageChangeParamsLike(getImageChangeParams() != null ? getImageChangeParams(): new DeploymentTriggerImageChangeParamsBuilder().build());
    }

    public io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent.ImageChangeParamsNested<A> editOrNewImageChangeParamsLike(DeploymentTriggerImageChangeParams item) {
        return withNewImageChangeParamsLike(getImageChangeParams() != null ? getImageChangeParams(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeploymentTriggerPolicyFluentImpl that = (DeploymentTriggerPolicyFluentImpl) o;
        if (imageChangeParams != null ? !imageChangeParams.equals(that.imageChangeParams) :that.imageChangeParams != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(imageChangeParams,  type,  super.hashCode());
    }

    public class ImageChangeParamsNestedImpl<N> extends DeploymentTriggerImageChangeParamsFluentImpl<io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent.ImageChangeParamsNested<N>> implements io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent.ImageChangeParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeploymentTriggerImageChangeParamsBuilder builder;

            ImageChangeParamsNestedImpl(DeploymentTriggerImageChangeParams item) {
                this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
                        
            }

            ImageChangeParamsNestedImpl() {
                this.builder = new DeploymentTriggerImageChangeParamsBuilder(this);
                        
            }

            public N and() {
                return (N) DeploymentTriggerPolicyFluentImpl.this.withImageChangeParams(builder.build());
            }

            public N endImageChangeParams() {
                return and();
            }
    }


}
