package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CustomDeploymentStrategyParamsFluentImpl<A extends CustomDeploymentStrategyParamsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CustomDeploymentStrategyParamsFluent<A> {

    private List<String> command = new ArrayList<String>();
    private List<EnvVar> environment = new ArrayList<EnvVar>();
    private String image;

    public CustomDeploymentStrategyParamsFluentImpl() {
    }

    public CustomDeploymentStrategyParamsFluentImpl(CustomDeploymentStrategyParams instance) {
        this.withCommand(instance.getCommand()); 
        this.withEnvironment(instance.getEnvironment()); 
        this.withImage(instance.getImage()); 
    }

    public A addToCommand(int index,String item) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        this.command.add(index, item);
        return (A)this;
    }

    public A setToCommand(int index,String item) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        this.command.set(index, item); return (A)this;
    }

    public A addToCommand(String... items) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(String... items) {
        for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item: command) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item: command) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCommand(List<String> command) {
        if (this.command != null) { _visitables.get("command").removeAll(this.command);}
        if (command != null) {this.command = new ArrayList<String>(); for (String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
    }

    public A withCommand(String... command) {
        if (this.command != null) {this.command.clear();}
        if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public Boolean hasCommand() {
        return command != null && !command.isEmpty();
    }

    public A addNewCommand(StringBuilder arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(int[] arg1,int arg2,int arg3) {
        return (A)addToCommand(new String(arg1, arg2, arg3));
    }

    public A addNewCommand(char[] arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(StringBuffer arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(byte[] arg1,int arg2) {
        return (A)addToCommand(new String(arg1, arg2));
    }

    public A addNewCommand(byte[] arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(char[] arg1,int arg2,int arg3) {
        return (A)addToCommand(new String(arg1, arg2, arg3));
    }

    public A addNewCommand(byte[] arg1,int arg2,int arg3) {
        return (A)addToCommand(new String(arg1, arg2, arg3));
    }

    public A addNewCommand(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToCommand(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewCommand(String arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addToEnvironment(int index,EnvVar item) {
        if (this.environment == null) {this.environment = new ArrayList<EnvVar>();}
        this.environment.add(index, item);
        return (A)this;
    }

    public A setToEnvironment(int index,EnvVar item) {
        if (this.environment == null) {this.environment = new ArrayList<EnvVar>();}
        this.environment.set(index, item); return (A)this;
    }

    public A addToEnvironment(EnvVar... items) {
        if (this.environment == null) {this.environment = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.environment.add(item);} return (A)this;
    }

    public A addAllToEnvironment(Collection<EnvVar> items) {
        if (this.environment == null) {this.environment = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.environment.add(item);} return (A)this;
    }

    public A removeFromEnvironment(EnvVar... items) {
        for (EnvVar item : items) {if (this.environment!= null){ this.environment.remove(item);}} return (A)this;
    }

    public A removeAllFromEnvironment(Collection<EnvVar> items) {
        for (EnvVar item : items) {if (this.environment!= null){ this.environment.remove(item);}} return (A)this;
    }

    public List<EnvVar> getEnvironment() {
        return this.environment;
    }

    public EnvVar getEnvironment(int index) {
        return this.environment.get(index);
    }

    public EnvVar getFirstEnvironment() {
        return this.environment.get(0);
    }

    public EnvVar getLastEnvironment() {
        return this.environment.get(environment.size() - 1);
    }

    public EnvVar getMatchingEnvironment(Predicate<EnvVar> predicate) {
        for (EnvVar item: environment) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnvironment(Predicate<EnvVar> predicate) {
        for (EnvVar item: environment) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnvironment(List<EnvVar> environment) {
        if (this.environment != null) { _visitables.get("environment").removeAll(this.environment);}
        if (environment != null) {this.environment = new ArrayList<EnvVar>(); for (EnvVar item : environment){this.addToEnvironment(item);}} else { this.environment = null;} return (A) this;
    }

    public A withEnvironment(EnvVar... environment) {
        if (this.environment != null) {this.environment.clear();}
        if (environment != null) {for (EnvVar item :environment){ this.addToEnvironment(item);}} return (A) this;
    }

    public Boolean hasEnvironment() {
        return environment != null && !environment.isEmpty();
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomDeploymentStrategyParamsFluentImpl that = (CustomDeploymentStrategyParamsFluentImpl) o;
        if (command != null ? !command.equals(that.command) :that.command != null) return false;
        if (environment != null ? !environment.equals(that.environment) :that.environment != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(command,  environment,  image,  super.hashCode());
    }

}
