package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface CustomBuildStrategyFluent<A extends CustomBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getBuildAPIVersion();
    public A withBuildAPIVersion(String buildAPIVersion);
    public Boolean hasBuildAPIVersion();
    public A withNewBuildAPIVersion(StringBuilder arg1);
    public A withNewBuildAPIVersion(int[] arg1,int arg2,int arg3);
    public A withNewBuildAPIVersion(char[] arg1);
    public A withNewBuildAPIVersion(StringBuffer arg1);
    public A withNewBuildAPIVersion(byte[] arg1,int arg2);
    public A withNewBuildAPIVersion(byte[] arg1);
    public A withNewBuildAPIVersion(char[] arg1,int arg2,int arg3);
    public A withNewBuildAPIVersion(byte[] arg1,int arg2,int arg3);
    public A withNewBuildAPIVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBuildAPIVersion(String arg1);
    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public List<EnvVar> getEnv();
    public EnvVar getEnv(int index);
    public EnvVar getFirstEnv();
    public EnvVar getLastEnv();
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public Boolean getExposeDockerSocket();
    public A withExposeDockerSocket(Boolean exposeDockerSocket);
    public Boolean hasExposeDockerSocket();
    public A withNewExposeDockerSocket(String arg1);
    public A withNewExposeDockerSocket(boolean arg1);
    public Boolean getForcePull();
    public A withForcePull(Boolean forcePull);
    public Boolean hasForcePull();
    public A withNewForcePull(String arg1);
    public A withNewForcePull(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getFrom();
    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom();
    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from);
    public Boolean hasFrom();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> withNewFrom();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> editFrom();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> editOrNewFrom();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    
/**
 * This method has been deprecated, please use method buildPullSecret instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getPullSecret();
    public LocalObjectReference buildPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public Boolean hasPullSecret();
    public A withNewPullSecret(String name);
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
    public A addToSecrets(int index,SecretSpec item);
    public A setToSecrets(int index,SecretSpec item);
    public A addToSecrets(SecretSpec... items);
    public A addAllToSecrets(Collection<SecretSpec> items);
    public A removeFromSecrets(SecretSpec... items);
    public A removeAllFromSecrets(Collection<SecretSpec> items);
    public A removeMatchingFromSecrets(Predicate<SecretSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<SecretSpec> getSecrets();
    public List<SecretSpec> buildSecrets();
    public SecretSpec buildSecret(int index);
    public SecretSpec buildFirstSecret();
    public SecretSpec buildLastSecret();
    public SecretSpec buildMatchingSecret(Predicate<SecretSpecBuilder> predicate);
    public Boolean hasMatchingSecret(Predicate<SecretSpecBuilder> predicate);
    public A withSecrets(List<SecretSpec> secrets);
    public A withSecrets(SecretSpec... secrets);
    public Boolean hasSecrets();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> addNewSecret();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> addNewSecretLike(SecretSpec item);
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> setNewSecretLike(int index,SecretSpec item);
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> editSecret(int index);
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> editFirstSecret();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> editLastSecret();
    public io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<A> editMatchingSecret(Predicate<SecretSpecBuilder> predicate);
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.openshift.api.model.CustomBuildStrategyFluent.FromNested<N>> {

            public N and();
            public N endFrom();    }


    public interface PullSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<io.fabric8.openshift.api.model.CustomBuildStrategyFluent.PullSecretNested<N>> {

            public N and();
            public N endPullSecret();    }


    public interface SecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretSpecFluent<io.fabric8.openshift.api.model.CustomBuildStrategyFluent.SecretsNested<N>> {

            public N and();
            public N endSecret();    }


}
