package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuffer;

public interface BuildRequestFluent<A extends BuildRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    
/**
 * This method has been deprecated, please use method buildBinary instead.
 * @return The buildable object.
 */
@Deprecated public BinaryBuildSource getBinary();
    public BinaryBuildSource buildBinary();
    public A withBinary(BinaryBuildSource binary);
    public Boolean hasBinary();
    public A withNewBinary(String asFile);
    public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> withNewBinary();
    public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> editBinary();
    public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> editOrNewBinary();
    public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item);
    
/**
 * This method has been deprecated, please use method buildDockerStrategyOptions instead.
 * @return The buildable object.
 */
@Deprecated public DockerStrategyOptions getDockerStrategyOptions();
    public DockerStrategyOptions buildDockerStrategyOptions();
    public A withDockerStrategyOptions(DockerStrategyOptions dockerStrategyOptions);
    public Boolean hasDockerStrategyOptions();
    public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> withNewDockerStrategyOptions();
    public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> withNewDockerStrategyOptionsLike(DockerStrategyOptions item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> editDockerStrategyOptions();
    public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptions();
    public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptionsLike(DockerStrategyOptions item);
    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public List<EnvVar> getEnv();
    public EnvVar getEnv(int index);
    public EnvVar getFirstEnv();
    public EnvVar getLastEnv();
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getFrom();
    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom();
    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from);
    public Boolean hasFrom();
    public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> withNewFrom();
    public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> editFrom();
    public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> editOrNewFrom();
    public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public Long getLastVersion();
    public A withLastVersion(Long lastVersion);
    public Boolean hasLastVersion();
    public A withNewLastVersion(long arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> editMetadata();
    public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildRevision instead.
 * @return The buildable object.
 */
@Deprecated public SourceRevision getRevision();
    public SourceRevision buildRevision();
    public A withRevision(SourceRevision revision);
    public Boolean hasRevision();
    public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> withNewRevision();
    public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> editRevision();
    public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> editOrNewRevision();
    public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item);
    
/**
 * This method has been deprecated, please use method buildSourceStrategyOptions instead.
 * @return The buildable object.
 */
@Deprecated public SourceStrategyOptions getSourceStrategyOptions();
    public SourceStrategyOptions buildSourceStrategyOptions();
    public A withSourceStrategyOptions(SourceStrategyOptions sourceStrategyOptions);
    public Boolean hasSourceStrategyOptions();
    public A withNewSourceStrategyOptions(Boolean incremental);
    public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> withNewSourceStrategyOptions();
    public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> withNewSourceStrategyOptionsLike(SourceStrategyOptions item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> editSourceStrategyOptions();
    public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptions();
    public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptionsLike(SourceStrategyOptions item);
    public A addToTriggeredBy(int index,BuildTriggerCause item);
    public A setToTriggeredBy(int index,BuildTriggerCause item);
    public A addToTriggeredBy(BuildTriggerCause... items);
    public A addAllToTriggeredBy(Collection<BuildTriggerCause> items);
    public A removeFromTriggeredBy(BuildTriggerCause... items);
    public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items);
    public A removeMatchingFromTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTriggeredBy instead.
 * @return The buildable object.
 */
@Deprecated public List<BuildTriggerCause> getTriggeredBy();
    public List<BuildTriggerCause> buildTriggeredBy();
    public BuildTriggerCause buildTriggeredBy(int index);
    public BuildTriggerCause buildFirstTriggeredBy();
    public BuildTriggerCause buildLastTriggeredBy();
    public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate);
    public Boolean hasMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate);
    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy);
    public A withTriggeredBy(BuildTriggerCause... triggeredBy);
    public Boolean hasTriggeredBy();
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> addNewTriggeredBy();
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> setNewTriggeredByLike(int index,BuildTriggerCause item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> editTriggeredBy(int index);
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> editFirstTriggeredBy();
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> editLastTriggeredBy();
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTriggeredByImage instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getTriggeredByImage();
    public io.fabric8.kubernetes.api.model.ObjectReference buildTriggeredByImage();
    public A withTriggeredByImage(io.fabric8.kubernetes.api.model.ObjectReference triggeredByImage);
    public Boolean hasTriggeredByImage();
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImage();
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImageLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> editTriggeredByImage();
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImage();
    public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImageLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public interface BinaryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BinaryBuildSourceFluent<io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<N>> {

            public N and();
            public N endBinary();    }


    public interface DockerStrategyOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DockerStrategyOptionsFluent<io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<N>> {

            public N and();
            public N endDockerStrategyOptions();    }


    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<N>> {

            public N and();
            public N endFrom();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface RevisionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceRevisionFluent<io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<N>> {

            public N and();
            public N endRevision();    }


    public interface SourceStrategyOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceStrategyOptionsFluent<io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<N>> {

            public N and();
            public N endSourceStrategyOptions();    }


    public interface TriggeredByNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildTriggerCauseFluent<io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<N>> {

            public N and();
            public N endTriggeredBy();    }


    public interface TriggeredByImageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<N>> {

            public N and();
            public N endTriggeredByImage();    }


}
