package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildConfigStatusBuilder extends BuildConfigStatusFluentImpl<BuildConfigStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<BuildConfigStatus,BuildConfigStatusBuilder> {

    BuildConfigStatusFluent<?> fluent;
    Boolean validationEnabled;

    public BuildConfigStatusBuilder() {
        this(true);
    }

    public BuildConfigStatusBuilder(Boolean validationEnabled) {
        this(new BuildConfigStatus(), validationEnabled);
    }

    public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BuildConfigStatus(), validationEnabled);
    }

    public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent,BuildConfigStatus instance) {
        this(fluent, instance, true);
    }

    public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent,BuildConfigStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastVersion(instance.getLastVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildConfigStatusBuilder(BuildConfigStatus instance) {
        this(instance,true);
    }

    public BuildConfigStatusBuilder(BuildConfigStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastVersion(instance.getLastVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildConfigStatus build() {
        BuildConfigStatus buildable = new BuildConfigStatus(fluent.getLastVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildConfigStatusBuilder that = (BuildConfigStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
