package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;
import java.lang.StringBuffer;

public interface BuildConfigSpecFluent<A extends BuildConfigSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Long getCompletionDeadlineSeconds();
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds);
    public Boolean hasCompletionDeadlineSeconds();
    public A withNewCompletionDeadlineSeconds(long arg1);
    public Integer getFailedBuildsHistoryLimit();
    public A withFailedBuildsHistoryLimit(Integer failedBuildsHistoryLimit);
    public Boolean hasFailedBuildsHistoryLimit();
    public A withNewFailedBuildsHistoryLimit(int arg0);
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(java.util.Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(java.util.Map<String,String> map);
    public java.util.Map<String,String> getNodeSelector();
    public <K extends Object,V extends Object>A withNodeSelector(java.util.Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    
/**
 * This method has been deprecated, please use method buildOutput instead.
 * @return The buildable object.
 */
@Deprecated public BuildOutput getOutput();
    public BuildOutput buildOutput();
    public A withOutput(BuildOutput output);
    public Boolean hasOutput();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> withNewOutput();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> editOutput();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> editOrNewOutput();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<A> editOrNewOutputLike(BuildOutput item);
    
/**
 * This method has been deprecated, please use method buildPostCommit instead.
 * @return The buildable object.
 */
@Deprecated public BuildPostCommitSpec getPostCommit();
    public BuildPostCommitSpec buildPostCommit();
    public A withPostCommit(BuildPostCommitSpec postCommit);
    public Boolean hasPostCommit();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommit();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> editPostCommit();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommit();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources();
    public ResourceRequirements buildResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> withNewResources();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> editResources();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> editOrNewResources();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    
/**
 * This method has been deprecated, please use method buildRevision instead.
 * @return The buildable object.
 */
@Deprecated public SourceRevision getRevision();
    public SourceRevision buildRevision();
    public A withRevision(SourceRevision revision);
    public Boolean hasRevision();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> withNewRevision();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> editRevision();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> editOrNewRevision();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item);
    public String getRunPolicy();
    public A withRunPolicy(String runPolicy);
    public Boolean hasRunPolicy();
    public A withNewRunPolicy(StringBuilder arg1);
    public A withNewRunPolicy(int[] arg1,int arg2,int arg3);
    public A withNewRunPolicy(char[] arg1);
    public A withNewRunPolicy(StringBuffer arg1);
    public A withNewRunPolicy(byte[] arg1,int arg2);
    public A withNewRunPolicy(byte[] arg1);
    public A withNewRunPolicy(char[] arg1,int arg2,int arg3);
    public A withNewRunPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewRunPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRunPolicy(String arg1);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public A withNewServiceAccount(StringBuilder arg1);
    public A withNewServiceAccount(int[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(char[] arg1);
    public A withNewServiceAccount(StringBuffer arg1);
    public A withNewServiceAccount(byte[] arg1,int arg2);
    public A withNewServiceAccount(byte[] arg1);
    public A withNewServiceAccount(char[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceAccount(String arg1);
    
/**
 * This method has been deprecated, please use method buildSource instead.
 * @return The buildable object.
 */
@Deprecated public BuildSource getSource();
    public BuildSource buildSource();
    public A withSource(BuildSource source);
    public Boolean hasSource();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> withNewSource();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> editSource();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> editOrNewSource();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<A> editOrNewSourceLike(BuildSource item);
    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public BuildStrategy getStrategy();
    public BuildStrategy buildStrategy();
    public A withStrategy(BuildStrategy strategy);
    public Boolean hasStrategy();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> withNewStrategy();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> editStrategy();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategy();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item);
    public Integer getSuccessfulBuildsHistoryLimit();
    public A withSuccessfulBuildsHistoryLimit(Integer successfulBuildsHistoryLimit);
    public Boolean hasSuccessfulBuildsHistoryLimit();
    public A withNewSuccessfulBuildsHistoryLimit(int arg0);
    public A addToTriggers(int index,BuildTriggerPolicy item);
    public A setToTriggers(int index,BuildTriggerPolicy item);
    public A addToTriggers(BuildTriggerPolicy... items);
    public A addAllToTriggers(Collection<BuildTriggerPolicy> items);
    public A removeFromTriggers(BuildTriggerPolicy... items);
    public A removeAllFromTriggers(Collection<BuildTriggerPolicy> items);
    public A removeMatchingFromTriggers(Predicate<BuildTriggerPolicyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTriggers instead.
 * @return The buildable object.
 */
@Deprecated public List<BuildTriggerPolicy> getTriggers();
    public List<BuildTriggerPolicy> buildTriggers();
    public BuildTriggerPolicy buildTrigger(int index);
    public BuildTriggerPolicy buildFirstTrigger();
    public BuildTriggerPolicy buildLastTrigger();
    public BuildTriggerPolicy buildMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate);
    public Boolean hasMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate);
    public A withTriggers(List<BuildTriggerPolicy> triggers);
    public A withTriggers(BuildTriggerPolicy... triggers);
    public Boolean hasTriggers();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> addNewTrigger();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> setNewTriggerLike(int index,BuildTriggerPolicy item);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> editTrigger(int index);
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> editFirstTrigger();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> editLastTrigger();
    public io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate);
    public interface OutputNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildOutputFluent<io.fabric8.openshift.api.model.BuildConfigSpecFluent.OutputNested<N>> {

            public N and();
            public N endOutput();    }


    public interface PostCommitNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildPostCommitSpecFluent<io.fabric8.openshift.api.model.BuildConfigSpecFluent.PostCommitNested<N>> {

            public N and();
            public N endPostCommit();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<io.fabric8.openshift.api.model.BuildConfigSpecFluent.ResourcesNested<N>> {

            public N and();
            public N endResources();    }


    public interface RevisionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceRevisionFluent<io.fabric8.openshift.api.model.BuildConfigSpecFluent.RevisionNested<N>> {

            public N and();
            public N endRevision();    }


    public interface SourceNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildSourceFluent<io.fabric8.openshift.api.model.BuildConfigSpecFluent.SourceNested<N>> {

            public N and();
            public N endSource();    }


    public interface StrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildStrategyFluent<io.fabric8.openshift.api.model.BuildConfigSpecFluent.StrategyNested<N>> {

            public N and();
            public N endStrategy();    }


    public interface TriggersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildTriggerPolicyFluent<io.fabric8.openshift.api.model.BuildConfigSpecFluent.TriggersNested<N>> {

            public N and();
            public N endTrigger();    }


}
