package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface AWSPlatformStatusFluent<A extends AWSPlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getRegion();
    public A withRegion(String region);
    public Boolean hasRegion();
    public A withNewRegion(StringBuilder arg1);
    public A withNewRegion(int[] arg1,int arg2,int arg3);
    public A withNewRegion(char[] arg1);
    public A withNewRegion(StringBuffer arg1);
    public A withNewRegion(byte[] arg1,int arg2);
    public A withNewRegion(byte[] arg1);
    public A withNewRegion(char[] arg1,int arg2,int arg3);
    public A withNewRegion(byte[] arg1,int arg2,int arg3);
    public A withNewRegion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRegion(String arg1);
    public A addToServiceEndpoints(int index,AWSServiceEndpoint item);
    public A setToServiceEndpoints(int index,AWSServiceEndpoint item);
    public A addToServiceEndpoints(AWSServiceEndpoint... items);
    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items);
    public A removeFromServiceEndpoints(AWSServiceEndpoint... items);
    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items);
    public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildServiceEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<AWSServiceEndpoint> getServiceEndpoints();
    public List<AWSServiceEndpoint> buildServiceEndpoints();
    public AWSServiceEndpoint buildServiceEndpoint(int index);
    public AWSServiceEndpoint buildFirstServiceEndpoint();
    public AWSServiceEndpoint buildLastServiceEndpoint();
    public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate);
    public Boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate);
    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints);
    public A withServiceEndpoints(AWSServiceEndpoint... serviceEndpoints);
    public Boolean hasServiceEndpoints();
    public A addNewServiceEndpoint(String name,String url);
    public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpoint();
    public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item);
    public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,AWSServiceEndpoint item);
    public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> editServiceEndpoint(int index);
    public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint();
    public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> editLastServiceEndpoint();
    public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate);
    public interface ServiceEndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AWSServiceEndpointFluent<io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<N>> {

            public N and();
            public N endServiceEndpoint();    }


}
