package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class APIServerServingCertsFluentImpl<A extends APIServerServingCertsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIServerServingCertsFluent<A> {

    private List<APIServerNamedServingCertBuilder> namedCertificates =  new ArrayList<APIServerNamedServingCertBuilder>();

    public APIServerServingCertsFluentImpl() {
    }

    public APIServerServingCertsFluentImpl(APIServerServingCerts instance) {
        this.withNamedCertificates(instance.getNamedCertificates()); 
    }

    public A addToNamedCertificates(int index,APIServerNamedServingCert item) {
        if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();}
        APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").add(index >= 0 ? index : _visitables.get("namedCertificates").size(), builder);this.namedCertificates.add(index >= 0 ? index : namedCertificates.size(), builder); return (A)this;
    }

    public A setToNamedCertificates(int index,APIServerNamedServingCert item) {
        if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();}
        APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);
        if (index < 0 || index >= _visitables.get("namedCertificates").size()) { _visitables.get("namedCertificates").add(builder); } else { _visitables.get("namedCertificates").set(index, builder);}
        if (index < 0 || index >= namedCertificates.size()) { namedCertificates.add(builder); } else { namedCertificates.set(index, builder);}
         return (A)this;
    }

    public A addToNamedCertificates(APIServerNamedServingCert... items) {
        if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();}
        for (APIServerNamedServingCert item : items) {APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").add(builder);this.namedCertificates.add(builder);} return (A)this;
    }

    public A addAllToNamedCertificates(Collection<APIServerNamedServingCert> items) {
        if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>();}
        for (APIServerNamedServingCert item : items) {APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").add(builder);this.namedCertificates.add(builder);} return (A)this;
    }

    public A removeFromNamedCertificates(APIServerNamedServingCert... items) {
        for (APIServerNamedServingCert item : items) {APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").remove(builder);if (this.namedCertificates != null) {this.namedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromNamedCertificates(Collection<APIServerNamedServingCert> items) {
        for (APIServerNamedServingCert item : items) {APIServerNamedServingCertBuilder builder = new APIServerNamedServingCertBuilder(item);_visitables.get("namedCertificates").remove(builder);if (this.namedCertificates != null) {this.namedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromNamedCertificates(Predicate<APIServerNamedServingCertBuilder> predicate) {
        if (namedCertificates == null) return (A) this;
        final Iterator<APIServerNamedServingCertBuilder> each = namedCertificates.iterator();
        final List visitables = _visitables.get("namedCertificates");
        while (each.hasNext()) {
          APIServerNamedServingCertBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildNamedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public List<APIServerNamedServingCert> getNamedCertificates() {
        return build(namedCertificates);
    }

    public List<APIServerNamedServingCert> buildNamedCertificates() {
        return build(namedCertificates);
    }

    public APIServerNamedServingCert buildNamedCertificate(int index) {
        return this.namedCertificates.get(index).build();
    }

    public APIServerNamedServingCert buildFirstNamedCertificate() {
        return this.namedCertificates.get(0).build();
    }

    public APIServerNamedServingCert buildLastNamedCertificate() {
        return this.namedCertificates.get(namedCertificates.size() - 1).build();
    }

    public APIServerNamedServingCert buildMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate) {
        for (APIServerNamedServingCertBuilder item: namedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate) {
        for (APIServerNamedServingCertBuilder item: namedCertificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNamedCertificates(List<APIServerNamedServingCert> namedCertificates) {
        if (this.namedCertificates != null) { _visitables.get("namedCertificates").removeAll(this.namedCertificates);}
        if (namedCertificates != null) {this.namedCertificates = new ArrayList<APIServerNamedServingCertBuilder>(); for (APIServerNamedServingCert item : namedCertificates){this.addToNamedCertificates(item);}} else { this.namedCertificates = null;} return (A) this;
    }

    public A withNamedCertificates(APIServerNamedServingCert... namedCertificates) {
        if (this.namedCertificates != null) {this.namedCertificates.clear();}
        if (namedCertificates != null) {for (APIServerNamedServingCert item :namedCertificates){ this.addToNamedCertificates(item);}} return (A) this;
    }

    public Boolean hasNamedCertificates() {
        return namedCertificates != null && !namedCertificates.isEmpty();
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> addNewNamedCertificate() {
        return new NamedCertificatesNestedImpl();
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> addNewNamedCertificateLike(APIServerNamedServingCert item) {
        return new NamedCertificatesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> setNewNamedCertificateLike(int index,APIServerNamedServingCert item) {
        return new NamedCertificatesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> editNamedCertificate(int index) {
        if (namedCertificates.size() <= index) throw new RuntimeException("Can't edit namedCertificates. Index exceeds size.");
        return setNewNamedCertificateLike(index, buildNamedCertificate(index));
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> editFirstNamedCertificate() {
        if (namedCertificates.size() == 0) throw new RuntimeException("Can't edit first namedCertificates. The list is empty.");
        return setNewNamedCertificateLike(0, buildNamedCertificate(0));
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> editLastNamedCertificate() {
        int index = namedCertificates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last namedCertificates. The list is empty.");
        return setNewNamedCertificateLike(index, buildNamedCertificate(index));
    }

    public io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<A> editMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate) {
        int index = -1;
        for (int i=0;i<namedCertificates.size();i++) { 
        if (predicate.test(namedCertificates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching namedCertificates. No match found.");
        return setNewNamedCertificateLike(index, buildNamedCertificate(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServerServingCertsFluentImpl that = (APIServerServingCertsFluentImpl) o;
        if (namedCertificates != null ? !namedCertificates.equals(that.namedCertificates) :that.namedCertificates != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(namedCertificates,  super.hashCode());
    }

    public class NamedCertificatesNestedImpl<N> extends APIServerNamedServingCertFluentImpl<io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<N>> implements io.fabric8.openshift.api.model.APIServerServingCertsFluent.NamedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServerNamedServingCertBuilder builder;
        private final int index;

            NamedCertificatesNestedImpl(int index,APIServerNamedServingCert item) {
                this.index = index;
                this.builder = new APIServerNamedServingCertBuilder(this, item);
                        
            }

            NamedCertificatesNestedImpl() {
                this.index = -1;
                this.builder = new APIServerNamedServingCertBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerServingCertsFluentImpl.this.setToNamedCertificates(index,builder.build());
            }

            public N endNamedCertificate() {
                return and();
            }
    }


}
